/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.skill;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import io.github.tigercrl.gokiskills.config.ConfigUtils;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.Skills;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

public class SkillRegistry {
    private static final ResourceKey<Registry<ISkill>> REGISTRY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("gokiskills", "skills"));
    private static Registry<ISkill> SKILL;
    private static final Logger LOGGER;

    public static void init(WritableRegistry<WritableRegistry<?>> writableRegistry, Map<ResourceLocation, Supplier<?>> LOADERS) {
        Lifecycle lifecycle = Lifecycle.stable();
        SKILL = new MappedRegistry(REGISTRY, lifecycle, false);
        LOADERS.put(REGISTRY.m_135782_(), () -> Skills.bootstrap(SKILL));
        writableRegistry.m_255290_(REGISTRY, (Object)((WritableRegistry)SKILL), lifecycle);
    }

    public static Map<String, JsonObject> getDefaultConfigs() {
        HashMap configs = new HashMap();
        SKILL.m_6579_().forEach(entry -> {
            try {
                configs.put(((ResourceKey)entry.getKey()).m_135782_().toString(), ConfigUtils.toJsonObject(((ISkill)entry.getValue()).getDefaultConfig()));
            }
            catch (Exception e) {
                LOGGER.warn("Error creating config for skill {}", (Object)((ResourceKey)entry.getKey()).m_135782_(), (Object)e);
            }
        });
        return Map.copyOf(configs);
    }

    public static ISkill getSkill(ResourceLocation location) {
        return (ISkill)SKILL.m_7745_(location);
    }

    public static ResourceLocation getLocation(ISkill skill) {
        return SKILL.m_7981_((Object)skill);
    }

    public static Set<ISkill> getSkills() {
        return SKILL.m_6579_().stream().map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static List<List<ISkill>> getSortedSkills() {
        Set<ISkill> skills = SkillRegistry.getSkills();
        HashMap skillCategories = new HashMap();
        skills.forEach(skill -> {
            if (skillCategories.containsKey(skill.getCategory())) {
                ((Map)skillCategories.get(skill.getCategory())).put(skill.getLocation(), skill);
            } else {
                HashMap<ResourceLocation, ISkill> category = new HashMap<ResourceLocation, ISkill>();
                category.put(skill.getLocation(), (ISkill)skill);
                skillCategories.put(skill.getCategory(), category);
            }
        });
        return skillCategories.entrySet().stream().sorted((e1, e2) -> SkillRegistry.compareResourceLocation((ResourceLocation)e1.getKey(), (ResourceLocation)e2.getKey())).map(Map.Entry::getValue).map(map -> map.entrySet().stream().sorted((e1, e2) -> SkillRegistry.compareResourceLocation((ResourceLocation)e1.getKey(), (ResourceLocation)e2.getKey())).map(Map.Entry::getValue).filter(ISkill::isEnabled).toList()).filter(list -> !list.isEmpty()).toList();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int compareResourceLocation(ResourceLocation location1, ResourceLocation location2) {
        boolean isGoki1 = location1.m_135827_().equals("gokiskills");
        boolean isGoki2 = location2.m_135827_().equals("gokiskills");
        if (isGoki1 && !isGoki2) {
            return -1;
        }
        if (!isGoki1 && isGoki2) {
            return 1;
        }
        int compare = location1.compareTo(location2);
        if (compare != 0) {
            return compare;
        }
        return location1.m_135815_().compareTo(location2.m_135815_());
    }

    static {
        LOGGER = LogUtils.getLogger();
    }
}

