/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.tigercrl.gokiskills.client.gui.screens.SkillsMenuScreen;
import io.github.tigercrl.gokiskills.network.C2SDowngradeMessage;
import io.github.tigercrl.gokiskills.network.C2SFastDowngradeMessage;
import io.github.tigercrl.gokiskills.network.C2SFastUpgradeMessage;
import io.github.tigercrl.gokiskills.network.C2SToggleMessage;
import io.github.tigercrl.gokiskills.network.C2SUpgradeMessage;
import io.github.tigercrl.gokiskills.skill.Skill;
import io.github.tigercrl.gokiskills.skill.SkillHelper;
import java.util.ArrayList;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class SkillButton
extends class_4185 {
    public static final int DEFAULT_WIDTH = 24;
    public static final int DEFAULT_HEIGHT = 24;
    public static final int DEFAULT_ICON_PADDING = 4;
    private static final class_2561 LOADING = class_2561.method_43471((String)"gui.gokiskills.loading.skill");
    private static final class_2561 DISABLED = class_2561.method_43471((String)"gui.gokiskills.disabled").method_27696(class_2583.field_24360.method_10977(class_124.field_1080));
    private static final class_2561 NO_DOWNGRADE = class_2561.method_43471((String)"gui.gokiskills.downgrade.no").method_27696(class_2583.field_24360.method_10977(class_124.field_1061));
    private static final class_2561 DOWNGRADE = class_2561.method_43471((String)"gui.gokiskills.downgrade").method_27696(class_2583.field_24360.method_36139(-13658630));
    private static final class_2561 NO_UPGRADE = class_2561.method_43471((String)"gui.gokiskills.upgrade.no").method_27696(class_2583.field_24360.method_10977(class_124.field_1061));
    private static final class_2561 UPGRADE = class_2561.method_43471((String)"gui.gokiskills.upgrade").method_27696(class_2583.field_24360.method_36139(-11535825));
    public static boolean hasControlDown = false;
    public static boolean hasShiftDown = false;
    public static boolean hasAltDown = false;
    private final Skill skill;
    private boolean waitForUpdate = false;
    public int level = 0;
    public boolean enabled = true;

    public SkillButton(int x, int y, Skill skill) {
        super(x, y, 24, 24, class_5244.field_39003, b -> {}, field_40754);
        this.skill = skill;
        this.updateLevel();
    }

    public void method_25306() {
        if (hasAltDown) {
            this.waitForUpdate = true;
            new C2SToggleMessage(this.skill.getLocation()).sendToServer();
        } else {
            int[] result = SkillHelper.calcOperation(this.skill, this.level, SkillsMenuScreen.playerXp, !hasControlDown, hasShiftDown);
            if (!this.waitForUpdate && result[0] != 0) {
                if (hasControlDown && hasShiftDown) {
                    if (this.level > this.skill.getMinLevel()) {
                        this.waitForUpdate = true;
                        new C2SFastDowngradeMessage(this.skill.getLocation()).sendToServer();
                    }
                } else if (hasControlDown) {
                    if (this.level > this.skill.getMinLevel()) {
                        this.waitForUpdate = true;
                        new C2SDowngradeMessage(this.skill.getLocation()).sendToServer();
                    }
                } else if (hasShiftDown) {
                    if (this.level < this.skill.getMaxLevel()) {
                        this.waitForUpdate = true;
                        new C2SFastUpgradeMessage(this.skill.getLocation()).sendToServer();
                    }
                } else if (this.level < this.skill.getMaxLevel()) {
                    this.waitForUpdate = true;
                    new C2SUpgradeMessage(this.skill.getLocation()).sendToServer();
                }
            }
        }
    }

    public void method_48579(class_332 guiGraphics, int i, int j, float f) {
        boolean isHovered = this.method_49606();
        boolean maxLevel = SkillHelper.getClientInfo().getLevel(this.skill) == this.skill.getMaxLevel();
        boolean operation = hasControlDown || hasShiftDown || hasAltDown;
        RenderSystem.enableBlend();
        guiGraphics.method_25291((class_2960)this.skill.getBackground().getItem(isHovered, maxLevel, operation), this.method_46426(), this.method_46427(), 0, 0.0f, 0.0f, this.field_22758, this.field_22759, this.skill.getBackground().getTextureWidth(), this.skill.getBackground().getTextureHeight());
        guiGraphics.method_25291((class_2960)this.skill.getOverlay().getItem(isHovered, maxLevel, operation), this.method_46426(), this.method_46427(), 0, 0.0f, 0.0f, this.field_22758, this.field_22759, this.skill.getOverlay().getTextureWidth(), this.skill.getOverlay().getTextureHeight());
        guiGraphics.method_25290((class_2960)this.skill.getIcon().getItem(isHovered, maxLevel, operation), this.method_46426() + 4, this.method_46427() + 4, 0.0f, 0.0f, this.field_22758 - 8, this.field_22759 - 8, this.skill.getIcon().getTextureWidth(), this.skill.getIcon().getTextureHeight());
        guiGraphics.method_25291((class_2960)this.skill.getFrame().getItem(isHovered, maxLevel, operation), this.method_46426() - 1, this.method_46427() - 1, 0, 0.0f, 0.0f, this.field_22758 + 2, this.field_22759 + 2, this.skill.getFrame().getTextureWidth(), this.skill.getFrame().getTextureHeight());
        RenderSystem.disableBlend();
        guiGraphics.method_27534(class_310.method_1551().field_1772, (class_2561)(this.waitForUpdate ? LOADING : (this.enabled ? class_2561.method_43470((String)(this.level + "/" + this.skill.getMaxLevel())) : DISABLED)), this.method_46426() + this.field_22758 / 2, this.method_46427() + this.field_22759 + 3, !this.waitForUpdate && maxLevel ? -9145 : 0xFFFFFF);
    }

    public void renderTooltip(class_332 guiGraphics, int i, int j) {
        boolean maxLevel;
        boolean bl = maxLevel = SkillHelper.getClientInfo().getLevel(this.skill) == this.skill.getMaxLevel();
        if (this.field_22762) {
            class_2561 click = null;
            class_5250 cost = null;
            int[] result = SkillHelper.calcOperation(this.skill, this.level, SkillsMenuScreen.playerXp, !hasControlDown, hasShiftDown);
            if (hasAltDown) {
                click = this.enabled ? class_2561.method_43471((String)"gui.gokiskills.toggle.off").method_27696(class_2583.field_24360.method_10977(class_124.field_1054)) : class_2561.method_43471((String)"gui.gokiskills.toggle.on").method_27696(class_2583.field_24360.method_10977(class_124.field_1054));
            } else if (hasControlDown) {
                if (result[0] == 0) {
                    click = NO_DOWNGRADE;
                } else if (hasShiftDown) {
                    click = class_2561.method_43469((String)"gui.gokiskills.downgrade.fast", (Object[])new Object[]{-result[0]}).method_27696(class_2583.field_24360.method_36139(-13658630));
                    cost = class_2561.method_43469((String)"gui.gokiskills.return", (Object[])new Object[]{result[1]}).method_27696(class_2583.field_24360.method_36139(-8405510));
                } else {
                    click = DOWNGRADE;
                    cost = class_2561.method_43469((String)"gui.gokiskills.return", (Object[])new Object[]{result[1]}).method_27696(class_2583.field_24360.method_36139(-8405510));
                }
            } else if (!maxLevel) {
                if (result[0] == 0) {
                    click = NO_UPGRADE;
                } else if (hasShiftDown) {
                    click = class_2561.method_43469((String)"gui.gokiskills.upgrade.fast", (Object[])new Object[]{result[0]}).method_27696(class_2583.field_24360.method_36139(-11535825));
                    cost = class_2561.method_43469((String)"gui.gokiskills.cost", (Object[])new Object[]{-result[1]}).method_27696(class_2583.field_24360.method_36139(-6291570));
                } else {
                    click = UPGRADE;
                    cost = class_2561.method_43469((String)"gui.gokiskills.cost", (Object[])new Object[]{-result[1]}).method_27696(class_2583.field_24360.method_36139(-6291570));
                }
            }
            ArrayList<Object> tooltipComponents = new ArrayList<Object>();
            tooltipComponents.add(this.skill.getName().method_27661().method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)(maxLevel ? class_2561.method_43471((String)"gui.gokiskills.max_level").method_27696(class_2583.field_24360.method_36139(this.enabled ? -9145 : 0xAAAAAA)) : class_2561.method_43470((String)("Lv" + this.level)))).method_27696(class_2583.field_24360.method_36139(this.enabled ? (maxLevel ? -13312 : 0xFFFFFF) : 0xAAAAAA)));
            tooltipComponents.add(this.skill.getDescription(this.level, this.skill.calcBonus(this.level)).method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1080)));
            if (click != null) {
                tooltipComponents.add(click);
            }
            if (cost != null) {
                tooltipComponents.add(cost);
            }
            guiGraphics.method_51437(class_310.method_1551().field_1772, tooltipComponents, Optional.empty(), i, j);
        }
    }

    public void updateLevel() {
        this.level = SkillHelper.getClientInfo().getLevel(this.skill);
        this.enabled = SkillHelper.getClientInfo().isEnabled(this.skill.getLocation());
        this.waitForUpdate = false;
    }
}

