/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.skill;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import io.github.tigercrl.gokiskills.config.ConfigUtils;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.Skills;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.slf4j.Logger;

public class SkillRegistry {
    private static final class_5321<class_2378<ISkill>> REGISTRY = class_5321.method_29180((class_2960)new class_2960("gokiskills", "skills"));
    private static class_2378<ISkill> SKILL;
    private static final Logger LOGGER;

    public static void init(class_2385<class_2385<?>> writableRegistry, Map<class_2960, Supplier<?>> LOADERS) {
        Lifecycle lifecycle = Lifecycle.stable();
        SKILL = new class_2370(REGISTRY, lifecycle, false);
        LOADERS.put(REGISTRY.method_29177(), () -> Skills.bootstrap(SKILL));
        writableRegistry.method_10272(REGISTRY, (Object)((class_2385)SKILL), lifecycle);
    }

    public static Map<String, JsonObject> getDefaultConfigs() {
        HashMap configs = new HashMap();
        SKILL.method_29722().forEach(entry -> {
            try {
                configs.put(((class_5321)entry.getKey()).method_29177().toString(), ConfigUtils.toJsonObject(((ISkill)entry.getValue()).getDefaultConfig()));
            }
            catch (Exception e) {
                LOGGER.warn("Error creating config for skill {}", (Object)((class_5321)entry.getKey()).method_29177(), (Object)e);
            }
        });
        return Map.copyOf(configs);
    }

    public static ISkill getSkill(class_2960 location) {
        return (ISkill)SKILL.method_10223(location);
    }

    public static class_2960 getLocation(ISkill skill) {
        return SKILL.method_10221((Object)skill);
    }

    public static Set<ISkill> getSkills() {
        return SKILL.method_29722().stream().map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    @Environment(value=EnvType.CLIENT)
    public static List<List<ISkill>> getSortedSkills() {
        Set<ISkill> skills = SkillRegistry.getSkills();
        HashMap skillCategories = new HashMap();
        skills.forEach(skill -> {
            if (skillCategories.containsKey(skill.getCategory())) {
                ((Map)skillCategories.get(skill.getCategory())).put(skill.getLocation(), skill);
            } else {
                HashMap<class_2960, ISkill> category = new HashMap<class_2960, ISkill>();
                category.put(skill.getLocation(), (ISkill)skill);
                skillCategories.put(skill.getCategory(), category);
            }
        });
        return skillCategories.entrySet().stream().sorted((e1, e2) -> SkillRegistry.compareResourceLocation((class_2960)e1.getKey(), (class_2960)e2.getKey())).map(Map.Entry::getValue).map(map -> map.entrySet().stream().sorted((e1, e2) -> SkillRegistry.compareResourceLocation((class_2960)e1.getKey(), (class_2960)e2.getKey())).map(Map.Entry::getValue).filter(ISkill::isEnabled).toList()).filter(list -> !list.isEmpty()).toList();
    }

    @Environment(value=EnvType.CLIENT)
    public static int compareResourceLocation(class_2960 location1, class_2960 location2) {
        boolean isGoki1 = location1.method_12836().equals("gokiskills");
        boolean isGoki2 = location2.method_12836().equals("gokiskills");
        if (isGoki1 && !isGoki2) {
            return -1;
        }
        if (!isGoki1 && isGoki2) {
            return 1;
        }
        int compare = location1.method_12833(location2);
        if (compare != 0) {
            return compare;
        }
        return location1.method_12832().compareTo(location2.method_12832());
    }

    static {
        LOGGER = LogUtils.getLogger();
    }
}

