/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.fabric;

import io.github.tigercrl.gokiskills.GokiSkills;
import io.github.tigercrl.gokiskills.misc.GokiServerPlayer;
import io.github.tigercrl.gokiskills.network.GokiNetwork;
import io.github.tigercrl.gokiskills.network.payloads.C2SConfigRequestPayload;
import io.github.tigercrl.gokiskills.network.payloads.C2SSkillDowngradePayload;
import io.github.tigercrl.gokiskills.network.payloads.C2SSkillFastDowngradePayload;
import io.github.tigercrl.gokiskills.network.payloads.C2SSkillFastUpgradePayload;
import io.github.tigercrl.gokiskills.network.payloads.C2SSkillInfoRequestPayload;
import io.github.tigercrl.gokiskills.network.payloads.C2SSkillTogglePayload;
import io.github.tigercrl.gokiskills.network.payloads.C2SSkillUpgradePayload;
import io.github.tigercrl.gokiskills.network.payloads.S2CConfigSyncPayload;
import io.github.tigercrl.gokiskills.network.payloads.S2CSkillInfoSyncPayload;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.world.entity.player.Player;

public final class GokiSkillsFabric
implements ModInitializer {
    public void onInitialize() {
        this.registerReceivers();
        GokiSkills.init();
    }

    private void registerReceivers() {
        PayloadTypeRegistry.playC2S().register(C2SSkillDowngradePayload.TYPE, C2SSkillDowngradePayload.STREAM_CODEC);
        PayloadTypeRegistry.playC2S().register(C2SSkillUpgradePayload.TYPE, C2SSkillUpgradePayload.STREAM_CODEC);
        PayloadTypeRegistry.playC2S().register(C2SSkillFastDowngradePayload.TYPE, C2SSkillFastDowngradePayload.STREAM_CODEC);
        PayloadTypeRegistry.playC2S().register(C2SSkillFastUpgradePayload.TYPE, C2SSkillFastUpgradePayload.STREAM_CODEC);
        PayloadTypeRegistry.playC2S().register(C2SSkillTogglePayload.TYPE, C2SSkillTogglePayload.STREAM_CODEC);
        PayloadTypeRegistry.playC2S().register(C2SConfigRequestPayload.TYPE, C2SConfigRequestPayload.STREAM_CODEC);
        PayloadTypeRegistry.playC2S().register(C2SSkillInfoRequestPayload.TYPE, C2SSkillInfoRequestPayload.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(S2CConfigSyncPayload.TYPE, S2CConfigSyncPayload.STREAM_CODEC);
        PayloadTypeRegistry.playS2C().register(S2CSkillInfoSyncPayload.TYPE, S2CSkillInfoSyncPayload.STREAM_CODEC);
        ServerPlayNetworking.registerGlobalReceiver(C2SSkillDowngradePayload.TYPE, (payload, context) -> GokiNetwork.handleSkillDowngrade(payload, (Player)context.player()));
        ServerPlayNetworking.registerGlobalReceiver(C2SSkillUpgradePayload.TYPE, (payload, context) -> GokiNetwork.handleSkillUpgrade(payload, (Player)context.player()));
        ServerPlayNetworking.registerGlobalReceiver(C2SSkillFastDowngradePayload.TYPE, (payload, context) -> GokiNetwork.handleSkillFastDowngrade(payload, (Player)context.player()));
        ServerPlayNetworking.registerGlobalReceiver(C2SSkillFastUpgradePayload.TYPE, (payload, context) -> GokiNetwork.handleSkillFastUpgrade(payload, (Player)context.player()));
        ServerPlayNetworking.registerGlobalReceiver(C2SSkillTogglePayload.TYPE, (payload, context) -> GokiNetwork.handleSkillToggle(payload, (Player)context.player()));
        ServerPlayNetworking.registerGlobalReceiver(C2SConfigRequestPayload.TYPE, (payload, context) -> GokiNetwork.sendConfigSync((Player)context.player()));
        ServerPlayNetworking.registerGlobalReceiver(C2SSkillInfoRequestPayload.TYPE, (payload, context) -> ((GokiServerPlayer)context.player()).syncSkillInfo());
    }
}

