/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.skill;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import io.github.tigercrl.gokiskills.GokiSkills;
import io.github.tigercrl.gokiskills.config.ConfigUtils;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.Skills;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.Bootstrap;
import org.slf4j.Logger;

public class SkillRegistry {
    private static final ResourceKey<Registry<ISkill>> REGISTRY = ResourceKey.createRegistryKey((ResourceLocation)GokiSkills.resource("skills"));
    private static Registry<ISkill> SKILL;
    private static final Logger LOGGER;

    public static void init(WritableRegistry<WritableRegistry<?>> WRITABLE_REGISTRY, Map<ResourceLocation, Supplier<?>> LOADERS) {
        Bootstrap.checkBootstrapCalled(() -> "registry " + String.valueOf(REGISTRY));
        ResourceLocation resourceLocation = REGISTRY.location();
        MappedRegistry writableRegistry = new MappedRegistry(REGISTRY, Lifecycle.stable(), false);
        LOADERS.put(resourceLocation, () -> SkillRegistry.lambda$init$1((WritableRegistry)writableRegistry));
        SKILL = writableRegistry;
        WRITABLE_REGISTRY.register(REGISTRY, (Object)writableRegistry, RegistrationInfo.BUILT_IN);
    }

    public static Map<String, JsonObject> getDefaultConfigs() {
        HashMap configs = new HashMap();
        SKILL.entrySet().forEach(entry -> {
            try {
                configs.put(((ResourceKey)entry.getKey()).location().toString(), ConfigUtils.toJsonObject(((ISkill)entry.getValue()).getDefaultConfig()));
            }
            catch (Exception e) {
                LOGGER.warn("Error creating config for skill {}", (Object)((ResourceKey)entry.getKey()).location(), (Object)e);
            }
        });
        return Map.copyOf(configs);
    }

    public static ISkill getSkill(ResourceLocation location) {
        return (ISkill)((Holder.Reference)SKILL.get(location).orElseThrow()).value();
    }

    public static ResourceLocation getLocation(ISkill skill) {
        return SKILL.getKey((Object)skill);
    }

    public static Set<ISkill> getSkills() {
        return SKILL.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    @Environment(value=EnvType.CLIENT)
    public static List<List<ISkill>> getSortedSkills() {
        Set<ISkill> skills = SkillRegistry.getSkills();
        HashMap skillCategories = new HashMap();
        skills.forEach(skill -> {
            if (skillCategories.containsKey(skill.getCategory())) {
                ((Map)skillCategories.get(skill.getCategory())).put(skill.getLocation(), skill);
            } else {
                HashMap<ResourceLocation, ISkill> category = new HashMap<ResourceLocation, ISkill>();
                category.put(skill.getLocation(), (ISkill)skill);
                skillCategories.put(skill.getCategory(), category);
            }
        });
        return skillCategories.entrySet().stream().sorted((e1, e2) -> SkillRegistry.compareResourceLocation((ResourceLocation)e1.getKey(), (ResourceLocation)e2.getKey())).map(Map.Entry::getValue).map(map -> map.entrySet().stream().sorted((e1, e2) -> SkillRegistry.compareResourceLocation((ResourceLocation)e1.getKey(), (ResourceLocation)e2.getKey())).map(Map.Entry::getValue).filter(ISkill::isEnabled).toList()).filter(list -> !list.isEmpty()).toList();
    }

    @Environment(value=EnvType.CLIENT)
    public static int compareResourceLocation(ResourceLocation location1, ResourceLocation location2) {
        boolean isGoki1 = location1.getNamespace().equals("gokiskills");
        boolean isGoki2 = location2.getNamespace().equals("gokiskills");
        if (isGoki1 && !isGoki2) {
            return -1;
        }
        if (!isGoki1 && isGoki2) {
            return 1;
        }
        int compare = location1.compareTo(location2);
        if (compare != 0) {
            return compare;
        }
        return location1.getPath().compareTo(location2.getPath());
    }

    private static /* synthetic */ Object lambda$init$1(WritableRegistry writableRegistry) {
        return Skills.bootstrap((Registry<ISkill>)writableRegistry);
    }

    static {
        LOGGER = LogUtils.getLogger();
    }
}

