/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.config;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import io.github.tigercrl.gokiskills.config.ConfigException;
import io.github.tigercrl.gokiskills.config.GokiConfig;
import io.github.tigercrl.gokiskills.config.GsonIgnore;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.slf4j.Logger;

public class ConfigUtils {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            return fieldAttributes.getAnnotation(GsonIgnore.class) != null;
        }

        public boolean shouldSkipClass(Class aClass) {
            return false;
        }
    }}).create();
    private static final Logger LOGGER = LogUtils.getLogger();

    public static <T extends GokiConfig> T readConfig(String fileName, Class<T> configClass) {
        File file = new File("config", fileName + ".json");
        GokiConfig config = null;
        try {
            config = (GokiConfig)configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create config file: {}.json, using default config", (Object)fileName, (Object)e);
        }
        if (file.exists()) {
            try {
                config = (GokiConfig)ConfigUtils.deserialize(Files.readString(file.toPath()), configClass);
            }
            catch (Exception e) {
                LOGGER.error("Failed to read config file: {}.json, using default config", (Object)fileName, (Object)e);
            }
        }
        try {
            config.validatePostLoad();
        }
        catch (ConfigException e) {
            LOGGER.error("Failed to validate config file: {}.json", (Object)fileName, (Object)e);
            throw e;
        }
        ConfigUtils.saveConfig(fileName, config);
        return (T)config;
    }

    public static <T extends GokiConfig> void saveConfig(String fileName, T config) {
        try {
            File file = new File("config", fileName + ".json");
            if (!file.exists()) {
                file.getParentFile().mkdirs();
            }
            Files.writeString(file.toPath(), (CharSequence)ConfigUtils.serialize(config), StandardOpenOption.CREATE);
        }
        catch (Exception e) {
            LOGGER.error("Failed to save config file: {}.json", (Object)fileName, (Object)e);
        }
    }

    public static JsonObject toJsonObject(Object object) {
        return gson.toJsonTree(object).getAsJsonObject();
    }

    public static <T> T fromJsonObject(JsonObject jsonObject, Class<T> clazz) {
        return (T)gson.fromJson((JsonElement)jsonObject, clazz);
    }

    public static String serialize(Object object) {
        return gson.toJson(object);
    }

    public static <T> T deserialize(String json, Class<T> clazz) {
        return (T)gson.fromJson(json, clazz);
    }

    public static <T> StreamCodec<ByteBuf, T> streamCodecOf(Class<T> clazz) {
        return ByteBufCodecs.STRING_UTF8.map(str -> ConfigUtils.deserialize(str, clazz), ConfigUtils::serialize);
    }
}

