/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.skill;

import io.github.tigercrl.gokiskills.misc.GokiPlayer;
import io.github.tigercrl.gokiskills.misc.GokiServerPlayer;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.SkillInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class SkillHelper {
    public static SkillInfo getInfoOrNull(Player player) {
        return ((GokiPlayer)player).getSkillInfo();
    }

    public static SkillInfo getInfo(Player player) {
        SkillInfo info = SkillHelper.getInfoOrNull(player);
        return info == null ? new SkillInfo(player) : info;
    }

    public static int getTotalXp(Player player) {
        return ((GokiPlayer)player).getPlayerTotalXp();
    }

    public static void setSkillInfo(Player player, SkillInfo skillInfo) {
        ((GokiPlayer)player).setSkillInfo(skillInfo);
    }

    public static void updateSkill(Player player, ResourceLocation location, boolean upgrade, boolean fast) {
        ((GokiServerPlayer)player).updateSkill(location, upgrade, fast);
    }

    public static int[] calcOperation(ISkill skill, int level, int xp, boolean upgrade, boolean fast) {
        int addXp = 0;
        int addLevel = 0;
        if (upgrade) {
            if (fast) {
                int thisCost;
                while (level + addLevel < skill.getMaxLevel() && -addXp + (thisCost = skill.calcCost(level + addLevel)) <= xp) {
                    ++addLevel;
                    addXp -= thisCost;
                }
                return new int[]{addLevel, addXp};
            }
            addXp = skill.calcCost(level);
            if (addXp > xp || level + 1 > skill.getMaxLevel()) {
                return new int[]{0, 0};
            }
            return new int[]{1, -addXp};
        }
        if (fast) {
            while (level + addLevel > skill.getMinLevel()) {
                addXp += skill.calcReturn(level + addLevel);
                --addLevel;
            }
            return new int[]{addLevel, addXp};
        }
        if (level - 1 < skill.getMinLevel()) {
            return new int[]{0, 0};
        }
        addXp = skill.calcReturn(level);
        return new int[]{-1, addXp};
    }

    @OnlyIn(value=Dist.CLIENT)
    public static SkillInfo getClientInfoOrNull() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            return SkillHelper.getInfoOrNull((Player)player);
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static SkillInfo getClientInfo() {
        SkillInfo info = SkillHelper.getClientInfoOrNull();
        return info == null ? new SkillInfo((Player)Minecraft.getInstance().player) : info;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getClientTotalXp() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            return SkillHelper.getTotalXp((Player)player);
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setClientSkillInfo(SkillInfo skillInfo) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            SkillHelper.setSkillInfo((Player)player, SkillInfo.fromNbt((Player)player, skillInfo.toNbt()));
        }
    }
}

