/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.client;

import com.mojang.logging.LogUtils;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import io.github.tigercrl.gokiskills.client.gui.screens.SkillsMenuScreen;
import io.github.tigercrl.gokiskills.config.CommonConfig;
import io.github.tigercrl.gokiskills.network.C2SRequestConfigMessage;
import io.github.tigercrl.gokiskills.network.C2SRequestSkillInfoMessage;
import io.github.tigercrl.gokiskills.skill.SkillHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public final class GokiSkillsClient {
    public static CommonConfig serverConfig;
    public static long lastPlayerInfoUpdated;
    private static long nextSendTime;
    private static final Logger LOGGER;

    public static void init() {
        class_304 openMenuKey = new class_304("key.gokiskills.open", class_3675.class_307.field_1668, 89, "key.categories.gokiskills");
        KeyMappingRegistry.register((class_304)openMenuKey);
        ClientRawInputEvent.KEY_PRESSED.register((client, keyCode, scanCode, action, modifiers) -> {
            if (client.field_1687 != null && client.field_1755 == null && openMenuKey.method_1417(keyCode, scanCode)) {
                client.method_1507((class_437)new SkillsMenuScreen(null));
                return EventResult.interruptTrue();
            }
            return EventResult.pass();
        });
        ClientTickEvent.CLIENT_POST.register(client -> {
            long now;
            if (client.field_1687 != null && (now = class_156.method_658()) > nextSendTime) {
                if (serverConfig == null) {
                    new C2SRequestConfigMessage().sendToServer();
                }
                if (SkillHelper.getClientInfoOrNull() == null) {
                    new C2SRequestSkillInfoMessage().sendToServer();
                }
                nextSendTime = now + 5000L;
            }
        });
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(player -> {
            serverConfig = null;
            lastPlayerInfoUpdated = 0L;
        });
        LOGGER.info("GokiSkills initialized on client!");
    }

    static {
        lastPlayerInfoUpdated = 0L;
        nextSendTime = 0L;
        LOGGER = LogUtils.getLogger();
    }
}

