/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.skill;

import io.github.tigercrl.gokiskills.misc.GokiPlayer;
import io.github.tigercrl.gokiskills.misc.GokiServerPlayer;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.SkillInfo;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class SkillHelper {
    public static SkillInfo getInfoOrNull(class_1657 player) {
        return ((GokiPlayer)player).getSkillInfo();
    }

    public static SkillInfo getInfo(class_1657 player) {
        SkillInfo info = SkillHelper.getInfoOrNull(player);
        return info == null ? new SkillInfo(player) : info;
    }

    public static int getTotalXp(class_1657 player) {
        return ((GokiPlayer)player).getPlayerTotalXp();
    }

    public static void setSkillInfo(class_1657 player, SkillInfo skillInfo) {
        ((GokiPlayer)player).setSkillInfo(skillInfo);
    }

    public static void updateSkill(class_1657 player, class_2960 location, boolean upgrade, boolean fast) {
        ((GokiServerPlayer)player).updateSkill(location, upgrade, fast);
    }

    public static int[] calcOperation(ISkill skill, int level, int xp, boolean upgrade, boolean fast) {
        int addXp = 0;
        int addLevel = 0;
        if (upgrade) {
            if (fast) {
                int thisCost;
                while (level + addLevel < skill.getMaxLevel() && -addXp + (thisCost = skill.calcCost(level + addLevel)) <= xp) {
                    ++addLevel;
                    addXp -= thisCost;
                }
                return new int[]{addLevel, addXp};
            }
            addXp = skill.calcCost(level);
            if (addXp > xp || level + 1 > skill.getMaxLevel()) {
                return new int[]{0, 0};
            }
            return new int[]{1, -addXp};
        }
        if (fast) {
            while (level + addLevel > skill.getMinLevel()) {
                addXp += skill.calcReturn(level + addLevel);
                --addLevel;
            }
            return new int[]{addLevel, addXp};
        }
        if (level - 1 < skill.getMinLevel()) {
            return new int[]{0, 0};
        }
        addXp = skill.calcReturn(level);
        return new int[]{-1, addXp};
    }

    @Environment(value=EnvType.CLIENT)
    public static SkillInfo getClientInfoOrNull() {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            return SkillHelper.getInfoOrNull((class_1657)player);
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    public static SkillInfo getClientInfo() {
        SkillInfo info = SkillHelper.getClientInfoOrNull();
        return info == null ? new SkillInfo((class_1657)class_310.method_1551().field_1724) : info;
    }

    @Environment(value=EnvType.CLIENT)
    public static int getClientTotalXp() {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            return SkillHelper.getTotalXp((class_1657)player);
        }
        return 0;
    }

    @Environment(value=EnvType.CLIENT)
    public static void setClientSkillInfo(SkillInfo skillInfo) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            SkillHelper.setSkillInfo((class_1657)player, skillInfo);
        }
    }
}

