/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.mixin;

import io.github.tigercrl.gokiskills.misc.GokiServerPlayer;
import io.github.tigercrl.gokiskills.misc.GokiTags;
import io.github.tigercrl.gokiskills.skill.SkillInfo;
import io.github.tigercrl.gokiskills.skill.Skills;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Shadow
    protected boolean f_20899_;
    @Unique
    private static final List<LivingEntity> gokiskills$ignoreEntityHurt = new ArrayList<LivingEntity>();

    @Shadow
    public abstract boolean m_6147_();

    @Shadow
    public abstract boolean m_6469_(DamageSource var1, float var2);

    @Inject(method={"handleRelativeFrictionAndCalculateMovement"}, at={@At(value="RETURN")}, cancellable=true)
    public void climbBonus(Vec3 vec3, float f, CallbackInfoReturnable<Vec3> cir) {
        Player player;
        SkillInfo info;
        Entity entity = (Entity)this;
        if (entity instanceof Player && (info = SkillInfo.getInfo(player = (Player)entity)).isEnabled(Skills.CLIMBING) && (entity.horizontalCollision || this.f_20899_) && (this.m_6147_() || player.getFeetBlockState().is(Blocks.POWDER_SNOW) && PowderSnowBlock.canEntityWalkOnPowderSnow((Entity)player))) {
            double bonus = info.getBonus(Skills.CLIMBING);
            Vec3 vec = player.getDeltaMovement();
            if (bonus > 0.0 && vec.y > 0.0) {
                cir.setReturnValue((Object)new Vec3(vec.x, 0.2 * (1.0 + bonus), vec.z));
            }
        }
    }

    @Inject(method={"jumpFromGround"}, at={@At(value="TAIL")})
    public void jumpBonus(CallbackInfo ci) {
        Entity entity = (Entity)this;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            SkillInfo info = SkillInfo.getInfo(player);
            double jumpBoostBonus = info.isEnabled(Skills.JUMP_BOOST) ? info.getBonus(Skills.JUMP_BOOST) : 0.0;
            double leaperBonus = info.isEnabled(Skills.LEAPER) ? info.getBonus(Skills.LEAPER) : 0.0;
            player.setDeltaMovement(player.getDeltaMovement().multiply(leaperBonus + 1.0, jumpBoostBonus + 1.0, leaperBonus + 1.0));
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void hurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        SkillInfo info;
        ServerPlayer player;
        LivingEntity entity = (LivingEntity)this;
        float old = amount;
        if (gokiskills$ignoreEntityHurt.contains(entity)) {
            gokiskills$ignoreEntityHurt.remove(entity);
            return;
        }
        Entity entity2 = source.getEntity();
        if (entity2 instanceof ServerPlayer) {
            double bonus;
            player = (ServerPlayer)entity2;
            info = ((GokiServerPlayer)player).getSkillInfo();
            ItemStack item = player.getMainHandItem();
            if (info.isEnabled(Skills.ONE_HIT)) {
                bonus = info.getBonus(Skills.ONE_HIT);
                if ((double)entity.getHealth() < (double)entity.getMaxHealth() * 0.4 * bonus && Math.random() < bonus) {
                    if (entity.isInvulnerableTo(source) && entity.isInvulnerableTo(source = entity.damageSources().generic())) {
                        source = entity.damageSources().genericKill();
                    }
                    for (int i = 0; i < 500 && !entity.isDeadOrDying(); ++i) {
                        LivingEntityMixin.gokiskills$hurtEntity(entity, source, entity.getMaxHealth());
                    }
                    player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"skill.gokiskills.one_hit.message").withStyle(Style.EMPTY.withColor(ChatFormatting.RED))));
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_CRIT, SoundSource.PLAYERS, 1.0f, 1.0f);
                    player.playSound(SoundEvents.PLAYER_ATTACK_CRIT);
                    cir.setReturnValue((Object)true);
                }
            }
            if (info.isEnabled(Skills.NINJA) && player.isCrouching() && (bonus = info.getBonus(Skills.NINJA).doubleValue()) > 0.0) {
                amount *= (float)(1.0 + bonus * 0.25);
            }
            if (info.isEnabled(Skills.ARCHER) && item.getItem() instanceof ProjectileWeaponItem) {
                bonus = info.getBonus(Skills.ARCHER);
                if (bonus > 0.0) {
                    amount *= (float)(1.0 + bonus);
                }
            } else if (info.isEnabled(Skills.BOXING) && item.isEmpty()) {
                bonus = info.getBonus(Skills.BOXING);
                if (bonus > 0.0) {
                    amount *= (float)(1.0 + bonus);
                }
            } else if (info.isEnabled(Skills.FENCING) && item.is(ItemTags.SWORDS) && (bonus = info.getBonus(Skills.FENCING).doubleValue()) > 0.0) {
                amount *= (float)(1.0 + bonus);
            }
        }
        if (entity instanceof ServerPlayer && !(player = (ServerPlayer)entity).isInvulnerableTo(source) && !player.gameMode.isCreative()) {
            double bonus;
            info = ((GokiServerPlayer)player).getSkillInfo();
            if (info.isEnabled(Skills.DODGE) && source.is(GokiTags.CAN_DODGE) && Math.random() < info.getBonus(Skills.DODGE)) {
                player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"skill.gokiskills.dodge.message").withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD))));
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_NODAMAGE, SoundSource.PLAYERS, 1.0f, 1.0f);
                cir.setReturnValue((Object)false);
            }
            if (info.isEnabled(Skills.BLAST_PROTECTION) && source.is(DamageTypeTags.IS_EXPLOSION)) {
                double bonus2 = info.getBonus(Skills.BLAST_PROTECTION);
                if (bonus2 > 0.0) {
                    amount = (float)((double)amount * (1.0 - bonus2));
                }
            } else if (info.isEnabled(Skills.ENDOTHERMY) && (source.is(DamageTypeTags.IS_FIRE) || source.is(DamageTypeTags.IS_FREEZING))) {
                double bonus3 = info.getBonus(Skills.ENDOTHERMY);
                if (bonus3 > 0.0) {
                    amount = (float)((double)amount * (1.0 - bonus3));
                }
            } else if (info.isEnabled(Skills.FEATHER_FALLING) && source.is(DamageTypeTags.IS_FALL)) {
                double bonus4 = info.getBonus(Skills.FEATHER_FALLING);
                if (bonus4 > 0.0) {
                    amount = Mth.floor((double)((double)amount * (1.0 - bonus4)));
                }
            } else if (info.isEnabled(Skills.PROTECTION) && source.is(GokiTags.CAN_PROTECT) && (bonus = info.getBonus(Skills.PROTECTION).doubleValue()) > 0.0) {
                amount = (float)((double)amount * (1.0 - bonus));
            }
        }
        if (amount == old) {
            return;
        }
        LivingEntityMixin.gokiskills$hurtEntity(entity, source, amount);
        cir.setReturnValue((Object)true);
    }

    @Inject(method={"calculateFallDamage"}, at={@At(value="RETURN")}, cancellable=true)
    public void jumpBoostDamage(float f, float g, CallbackInfoReturnable<Integer> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            double bonus;
            SkillInfo info;
            Player p = (Player)livingEntity;
            if ((Integer)cir.getReturnValue() > 0 && (info = SkillInfo.getInfo(p)).isEnabled(Skills.JUMP_BOOST) && (bonus = info.getBonus(Skills.JUMP_BOOST).doubleValue()) > 0.0) {
                MobEffectInstance mobEffectInstance = p.getEffect(MobEffects.JUMP);
                int h = mobEffectInstance == null ? 0 : mobEffectInstance.getAmplifier() + 1;
                cir.setReturnValue((Object)Mth.ceil((double)(((double)(f - 3.0f - (float)h) - 3.5 * bonus) * (double)g)));
            }
        }
    }

    @Unique
    private static void gokiskills$hurtEntity(LivingEntity entity, DamageSource source, float amount) {
        gokiskills$ignoreEntityHurt.add(entity);
        entity.hurt(source, amount);
    }
}

