/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.mixin;

import io.github.tigercrl.gokiskills.misc.GokiServerPlayer;
import io.github.tigercrl.gokiskills.network.S2CSyncSkillInfoMessage;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.SkillHelper;
import io.github.tigercrl.gokiskills.skill.SkillInfo;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
implements GokiServerPlayer {
    @Shadow
    public ServerGamePacketListenerImpl f_8906_;

    @Shadow
    public abstract void m_6756_(int var1);

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void saveSkillsInfo(CompoundTag compoundTag, CallbackInfo ci) {
        CompoundTag tag = SkillHelper.getInfo((Player)this).toNbt();
        if (tag != null) {
            compoundTag.put("GokiSkills", (Tag)tag);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readSkillsInfo(CompoundTag compoundTag, CallbackInfo ci) {
        Player p = (Player)this;
        SkillHelper.setSkillInfo(p, SkillInfo.fromNbt(p, compoundTag.getCompound("GokiSkills")));
    }

    @Override
    @Unique
    public void updateSkill(ISkill skill, boolean upgrade, boolean fast) {
        ServerPlayer p = (ServerPlayer)this;
        SkillInfo info = SkillHelper.getInfo((Player)p);
        int level = info.getLevel(skill);
        int[] result = SkillHelper.calcOperation(skill, level, SkillHelper.getTotalXp((Player)p), upgrade, fast);
        info.setLevel(skill, level + result[0]);
        this.m_6756_(result[1]);
        this.f_8906_.send((Packet)new ClientboundSetExperiencePacket(p.experienceProgress, p.totalExperience, p.experienceLevel));
    }

    @Override
    @Unique
    public void syncSkillInfo() {
        ServerPlayer p = (ServerPlayer)this;
        new S2CSyncSkillInfoMessage(SkillHelper.getInfo((Player)p)).sendTo(p);
    }
}

