/*
 * Decompiled with CFR 0.152.
 */
package io.github.tigercrl.gokiskills.skill;

import io.github.tigercrl.gokiskills.GokiSkills;
import io.github.tigercrl.gokiskills.misc.GokiServerPlayer;
import io.github.tigercrl.gokiskills.misc.GokiUtils;
import io.github.tigercrl.gokiskills.skill.ISkill;
import io.github.tigercrl.gokiskills.skill.SkillEvents;
import io.github.tigercrl.gokiskills.skill.SkillRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class SkillInfo {
    public final int SCHEMA_VERSION = 1;
    private final Player player;
    private final Map<ResourceLocation, Integer> levels;
    private final Set<ResourceLocation> disabled;

    public SkillInfo(Player player) {
        this(player, new HashMap<ResourceLocation, Integer>(), new HashSet<ResourceLocation>());
    }

    protected SkillInfo(Player player, Map<ResourceLocation, Integer> levels, Set<ResourceLocation> disabled) {
        this.player = player;
        this.levels = levels;
        this.disabled = disabled;
        SkillRegistry.getSkills().forEach(skill -> levels.putIfAbsent(skill.getLocation(), skill.getDefaultLevel()));
    }

    public int getLevel(ISkill skill) {
        return this.levels.get(skill.getLocation());
    }

    public int getLevel(ResourceLocation location) {
        return this.getLevel(SkillRegistry.getSkill(location));
    }

    @Nullable
    public Double getBonus(ISkill skill) {
        return skill.calcBonus(this.isEnabled(skill) ? this.getLevel(skill) : skill.getDefaultLevel());
    }

    @Nullable
    public Double getBonus(ResourceLocation location) {
        return this.getBonus(SkillRegistry.getSkill(location));
    }

    public void setLevel(ISkill skill, int level) {
        this.levels.put(skill.getLocation(), level);
        ((SkillEvents.SkillInfoUpdate)SkillEvents.UPDATE.invoker()).update(skill, this.player, level, this.getLevel(skill), this);
        this.sync();
    }

    public void setLevel(ResourceLocation location, int level) {
        this.setLevel(SkillRegistry.getSkill(location), level);
    }

    public boolean isEnabled(ISkill skill) {
        return skill.isEnabled() && !this.disabled.contains(skill.getLocation());
    }

    public boolean isEnabled(ResourceLocation location) {
        return this.isEnabled(SkillRegistry.getSkill(location));
    }

    public void toggle(ISkill skill) {
        if (this.isEnabled(skill.getLocation())) {
            this.disabled.add(skill.getLocation());
        } else {
            this.disabled.remove(skill.getLocation());
        }
        ((SkillEvents.SkillInfoToggle)SkillEvents.TOGGLE.invoker()).toggle(skill, this.player, this.isEnabled(skill), this);
        this.sync();
    }

    public void toggle(ResourceLocation location) {
        this.toggle(SkillRegistry.getSkill(location));
    }

    public void onDeath() {
        if (GokiSkills.config.lostLevelOnDeath.enabled) {
            this.levels.forEach((key, value) -> {
                boolean lost;
                boolean bl = lost = Math.random() < GokiSkills.config.lostLevelOnDeath.chance;
                if (lost) {
                    ISkill s = SkillRegistry.getSkill(key);
                    int lostLevel = Math.min(GokiUtils.randomInt(GokiSkills.config.lostLevelOnDeath.minLevel, GokiSkills.config.lostLevelOnDeath.maxLevel + 1), value - s.getMinLevel());
                    if (lostLevel > 0) {
                        this.levels.put((ResourceLocation)key, value - lostLevel);
                        this.sync();
                    }
                }
            });
        }
    }

    public void sync() {
        Player player = this.player;
        if (player instanceof GokiServerPlayer) {
            GokiServerPlayer gp = (GokiServerPlayer)player;
            gp.syncSkillInfo();
        }
    }

    @Nullable
    public CompoundTag toNbt() {
        CompoundTag compoundTag = new CompoundTag();
        CompoundTag levelTag = new CompoundTag();
        this.levels.forEach((key, value) -> levelTag.putInt(key.toString(), value.intValue()));
        compoundTag.put("levels", (Tag)levelTag);
        ListTag disabledTag = new ListTag();
        this.disabled.forEach(key -> disabledTag.add((Object)StringTag.valueOf((String)key.toString())));
        compoundTag.put("disabled", (Tag)disabledTag);
        compoundTag.putInt("schema", 1);
        return compoundTag;
    }

    public void writeBuf(FriendlyByteBuf buf) {
        buf.writeMap(this.levels, FriendlyByteBuf::writeResourceLocation, FriendlyByteBuf::writeVarInt);
        buf.writeCollection(this.disabled, FriendlyByteBuf::writeResourceLocation);
    }

    public static SkillInfo fromBuf(Player player, FriendlyByteBuf buf) {
        return new SkillInfo(player, new HashMap<ResourceLocation, Integer>(buf.readMap(FriendlyByteBuf::readResourceLocation, FriendlyByteBuf::readVarInt)), (Set)buf.readCollection(HashSet::new, FriendlyByteBuf::readResourceLocation));
    }

    public static SkillInfo fromNbt(Player player, CompoundTag compoundTag) {
        HashMap<ResourceLocation, Integer> levels = new HashMap<ResourceLocation, Integer>();
        HashSet<ResourceLocation> disabled = new HashSet<ResourceLocation>();
        if (compoundTag.contains("schema")) {
            switch (compoundTag.getInt("schema")) {
                case 1: {
                    SkillInfo.readVer1(compoundTag, levels, disabled);
                }
            }
        } else if (compoundTag.contains("levels")) {
            SkillInfo.readVer1(compoundTag, levels, disabled);
        } else {
            SkillInfo.readVer0(compoundTag, levels);
        }
        return new SkillInfo(player, levels, disabled);
    }

    private static void readVer0(CompoundTag compoundTag, Map<ResourceLocation, Integer> levels) {
        compoundTag.getAllKeys().forEach(key -> levels.put(ResourceLocation.tryParse((String)key), compoundTag.getInt(key)));
    }

    private static void readVer1(CompoundTag compoundTag, Map<ResourceLocation, Integer> levels, Set<ResourceLocation> disabled) {
        CompoundTag levelTag = compoundTag.getCompound("levels");
        levelTag.getAllKeys().forEach(key -> levels.put(ResourceLocation.tryParse((String)key), levelTag.getInt(key)));
        if (compoundTag.contains("disabled")) {
            compoundTag.getList("disabled", 8).forEach(tag -> disabled.add(ResourceLocation.tryParse((String)tag.getAsString())));
        }
    }
}

