/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities;

import java.io.File;
import java.nio.file.Path;
import java.util.function.Function;
import java.util.function.Supplier;
import mcjty.lostcities.LostCitiesImp;
import mcjty.lostcities.LostCitiesPreImp;
import mcjty.lostcities.datagen.DataGenerators;
import mcjty.lostcities.network.PacketRequestProfile;
import mcjty.lostcities.network.PacketReturnProfileToClient;
import mcjty.lostcities.setup.ClientSetup;
import mcjty.lostcities.setup.Config;
import mcjty.lostcities.setup.CustomRegistries;
import mcjty.lostcities.setup.ModSetup;
import mcjty.lostcities.setup.Registration;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lostcities")
public class LostCities {
    public static final String MODID = "lostcities";
    public static final Logger LOGGER = LogManager.getLogger((String)"lostcities");
    public static final ModSetup setup = new ModSetup();
    public static LostCities instance;
    public static final LostCitiesImp lostCitiesImp;

    public LostCities(ModContainer container, IEventBus bus, Dist dist) {
        instance = this;
        Registration.init(bus);
        CustomRegistries.init(bus);
        Path configPath = FMLPaths.CONFIGDIR.get();
        File dir = new File(String.valueOf(configPath) + File.separator + MODID);
        dir.mkdirs();
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_CONFIG, "lostcities/client.toml");
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_CONFIG, "lostcities/common.toml");
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_CONFIG);
        setup.preInit();
        bus.addListener(setup::init);
        bus.addListener(this::onRegisterPayloadHandler);
        bus.addListener(this::processIMC);
        bus.addListener(this::onConstructModEvent);
        bus.addListener(CustomRegistries::onDataPackRegistry);
        bus.addListener(DataGenerators::gatherData);
        if (dist.isClient()) {
            bus.addListener(ClientSetup::init);
        }
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    private void onRegisterPayloadHandler(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID).versioned("1.0").optional();
        registrar.playToClient(PacketReturnProfileToClient.TYPE, PacketReturnProfileToClient.CODEC, PacketReturnProfileToClient::handle);
        registrar.playToServer(PacketRequestProfile.TYPE, PacketRequestProfile.CODEC, PacketRequestProfile::handle);
    }

    private void onConstructModEvent(FMLConstructModEvent event) {
        event.enqueueWork(() -> event.getIMCStream("getLostCitiesPre"::equals).forEach(message -> {
            Supplier supplier = message.getMessageSupplier();
            ((Function)supplier.get()).apply(new LostCitiesPreImp());
        }));
    }

    private void processIMC(InterModProcessEvent event) {
        event.getIMCStream("getLostCities"::equals).forEach(message -> {
            Supplier supplier = message.getMessageSupplier();
            ((Function)supplier.get()).apply(lostCitiesImp);
        });
    }

    static {
        lostCitiesImp = new LostCitiesImp();
    }
}

