/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import mcjty.lostcities.commands.ModCommands;
import mcjty.lostcities.editor.EditModeData;
import mcjty.lostcities.setup.Registration;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.ComponentFactory;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostCityFeature;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;

public class CommandLocatePart
implements Command<CommandSourceStack> {
    private static final CommandLocatePart CMD = new CommandLocatePart();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"locatepart").requires(cs -> cs.hasPermission(1))).then(Commands.argument((String)"name", (ArgumentType)ResourceLocationArgument.id()).suggests(ModCommands.getPartSuggestionProvider()).executes((Command)CMD));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ResourceLocation name = (ResourceLocation)context.getArgument("name", ResourceLocation.class);
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        BlockPos start = player.blockPosition();
        ServerLevel level = (ServerLevel)player.level();
        IDimensionInfo dimInfo = ((LostCityFeature)((Object)Registration.LOSTCITY_FEATURE.get())).getDimensionInfo((WorldGenLevel)level);
        if (dimInfo == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ComponentFactory.literal("This dimension doesn't support Lost Cities!"));
            return 0;
        }
        if (!dimInfo.getProfile().EDITMODE) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ComponentFactory.literal("This world was not created with edit mode enabled. This command is not possible!"));
            return 0;
        }
        ChunkPos cp = new ChunkPos(start);
        int cnt = 0;
        block0: for (BlockPos.MutableBlockPos mpos : BlockPos.spiralAround((BlockPos)new BlockPos(cp.x, 0, cp.z), (int)30, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            List<EditModeData.PartData> data = EditModeData.getData().getPartData(new ChunkCoord((ResourceKey<Level>)level.dimension(), mpos.getX(), mpos.getZ()));
            for (EditModeData.PartData pd : data) {
                if (!pd.partName().equals(name.toString())) continue;
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> ComponentFactory.literal("Found at " + ((mpos.getX() << 4) + 8) + "," + pd.y() + "," + ((mpos.getZ() << 4) + 8)), false);
                if (++cnt <= 6) continue;
                continue block0;
            }
        }
        return 0;
    }
}

