/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.datagen;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import mcjty.lostcities.worldgen.LostTags;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class LCBlockTags
extends BlockTagsProvider {
    private static final Set<TagKey<Block>> PLANT_TAGS = Set.of(BlockTags.CORAL_PLANTS, BlockTags.BAMBOO_BLOCKS, BlockTags.LOGS, BlockTags.LEAVES, BlockTags.SAPLINGS, BlockTags.FLOWERS);

    public LCBlockTags(DataGenerator generator, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper helper) {
        super(generator.getPackOutput(), lookupProvider, "lostcities", helper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        for (TagKey<Block> tag : PLANT_TAGS) {
            this.tag(LostTags.FOLIAGE_TAG).addTag(tag);
        }
        this.tag(LostTags.EASY_BREAKABLE_TAG).addTags(new TagKey[]{Tags.Blocks.GLASS_BLOCKS});
        BuiltInRegistries.BLOCK.stream().forEach(block -> {
            if (block.defaultBlockState().getDestroySpeed(null, null) < 0.6f) {
                this.tag(LostTags.EASY_BREAKABLE_TAG).add(block);
            }
        });
        this.tag(LostTags.ROTATABLE_TAG).addTag(BlockTags.STAIRS);
        this.tag(LostTags.NOT_BREAKABLE_TAG).add((Object[])new Block[]{Blocks.BEDROCK, Blocks.END_PORTAL, Blocks.END_PORTAL_FRAME, Blocks.END_GATEWAY});
        this.tag(LostTags.NEEDSPOI_TAG).add((Object[])new Block[]{Blocks.BREWING_STAND, Blocks.CAULDRON, Blocks.BARREL, Blocks.BLAST_FURNACE, Blocks.SMOKER, Blocks.COMPOSTER, Blocks.FLETCHING_TABLE, Blocks.LECTERN, Blocks.STONECUTTER, Blocks.LOOM, Blocks.SMITHING_TABLE, Blocks.GRINDSTONE});
    }

    @Nonnull
    public String getName() {
        return "LostCity Tags";
    }
}

