/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.WorldTools;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class EditModeData
extends SavedData {
    public static final String NAME = "LostCityEditData";
    private final Map<ChunkCoord, List<PartData>> partData = new HashMap<ChunkCoord, List<PartData>>();

    @Nonnull
    public static EditModeData getData() {
        ServerLevel overworld = WorldTools.getOverworld();
        DimensionDataStorage storage = overworld.getDataStorage();
        return (EditModeData)storage.computeIfAbsent(new SavedData.Factory(EditModeData::new, (compoundTag, provider) -> new EditModeData((CompoundTag)compoundTag)), NAME);
    }

    public EditModeData() {
    }

    public EditModeData(CompoundTag nbt) {
        ListTag data = nbt.getList("data", 10);
        for (Tag t : data) {
            CompoundTag pdTag = (CompoundTag)t;
            ResourceKey level = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)pdTag.getString("level")));
            int chunkX = pdTag.getInt("x");
            int chunkZ = pdTag.getInt("z");
            ChunkCoord pos = new ChunkCoord((ResourceKey<Level>)level, chunkX, chunkZ);
            String part = pdTag.getString("part");
            int y = pdTag.getInt("y");
            this.addPartData(pos, y, part);
        }
    }

    public void addPartData(ChunkCoord pos, int y, String partName) {
        this.partData.computeIfAbsent(pos, p -> new ArrayList()).add(new PartData(partName, y));
        this.setDirty();
    }

    public List<PartData> getPartData(ChunkCoord pos) {
        return this.partData.getOrDefault(pos, Collections.emptyList());
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag data = new ListTag();
        this.partData.forEach((pos, list) -> {
            for (PartData pd : list) {
                CompoundTag pdTag = new CompoundTag();
                pdTag.putString("level", pos.dimension().location().toString());
                pdTag.putInt("x", pos.chunkX());
                pdTag.putInt("z", pos.chunkZ());
                pdTag.putString("part", pd.partName());
                pdTag.putInt("y", pd.y());
                data.add((Object)pdTag);
            }
        });
        tag.put("data", (Tag)data);
        return tag;
    }

    public record PartData(String partName, int y) {
    }
}

