/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.gui.elements;

import mcjty.lostcities.config.Configuration;
import mcjty.lostcities.gui.GuiLCConfig;
import mcjty.lostcities.gui.elements.ButtonExt;
import mcjty.lostcities.gui.elements.GuiElement;
import mcjty.lostcities.varia.ComponentFactory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class BooleanElement
extends GuiElement {
    private final GuiLCConfig gui;
    private String label = null;
    private final ButtonExt field;
    private final String attribute;

    public BooleanElement(GuiLCConfig gui, String page, int x, int y, String attribute) {
        super(page, x, y);
        this.gui = gui;
        this.attribute = attribute;
        Boolean c = gui.getLocalSetup().get().map(h -> (Boolean)h.toConfiguration().get(attribute)).orElse(false);
        this.field = new ButtonExt(this, x, y, 60, 16, (Component)(c != false ? ComponentFactory.literal("On") : ComponentFactory.literal("Off")), button -> {
            Component message = button.getMessage();
            if ("On".equals(message.getString())) {
                button.setMessage((Component)ComponentFactory.literal("Off"));
            } else {
                button.setMessage((Component)ComponentFactory.literal("On"));
            }
            gui.getLocalSetup().get().ifPresent(profile -> {
                Configuration configuration = profile.toConfiguration();
                configuration.set(attribute, "On".equals(button.getMessage().getString()));
                profile.copyFromConfiguration(configuration);
                gui.refreshPreview();
            });
        }){};
        gui.addWidget(this.field);
    }

    public BooleanElement label(String label) {
        this.label = label;
        return this;
    }

    @Override
    public void render(GuiGraphics graphics) {
        if (this.label != null && this.field.visible) {
            graphics.drawString(this.gui.getFont(), this.label, 10, this.y + 5, -1);
        }
    }

    @Override
    public void update() {
        this.gui.getLocalSetup().get().ifPresent(profile -> {
            Boolean result = (Boolean)profile.toConfiguration().get(this.attribute);
            this.field.setMessage((Component)(result != false ? ComponentFactory.literal("On") : ComponentFactory.literal("Off")));
        });
    }

    @Override
    public void setEnabled(boolean b) {
        this.field.active = b;
    }

    @Override
    public void setBasedOnMode(String mode) {
        this.field.visible = this.page.equalsIgnoreCase(mode);
    }
}

