/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.gen;

import java.util.List;
import mcjty.lostcities.worldgen.ChunkDriver;
import mcjty.lostcities.worldgen.LostCityTerrainFeature;
import mcjty.lostcities.worldgen.lost.BiomeInfo;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.CompiledPalette;
import mcjty.lostcities.worldgen.lost.cityassets.StuffObject;
import mcjty.lostcities.worldgen.lost.regassets.StuffSettingsRE;
import mcjty.lostcities.worldgen.lost.regassets.data.BlockMatcher;
import mcjty.lostcities.worldgen.lost.regassets.data.ResourceLocationMatcher;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;

public class Stuff {
    public static void generateStuff(LostCityTerrainFeature feature, BuildingInfo info) {
        feature.rand.setSeed((long)info.coord.chunkX() * 2570174657L + (long)info.coord.chunkZ() * 101754695981L);
        BiomeInfo biome = BiomeInfo.getBiomeInfo(feature.provider, info.coord);
        CompiledPalette palette = info.getCompiledPalette();
        for (String tag : info.getCityStyle().getStuffTags()) {
            List<StuffObject> stuffs = AssetRegistries.STUFF_BY_TAG.get(tag);
            if (stuffs == null) continue;
            for (StuffObject stuff : stuffs) {
                ResourceLocationMatcher buildingMatcher;
                StuffSettingsRE settings = stuff.getSettings();
                Boolean inBuilding = settings.isInBuilding();
                if (inBuilding == null || inBuilding != info.hasBuilding || !(buildingMatcher = settings.getBuildingMatcher()).isAny() && !buildingMatcher.test(info.buildingType.getId()) || !settings.getBiomeMatcher().test(biome.getMainBiome())) continue;
                Stuff.actuallyGenerateStuff(feature, info, settings, palette, inBuilding == Boolean.TRUE);
            }
        }
    }

    private static boolean testBlock(ChunkDriver driver, BlockMatcher matcher, int x, int y, int z) {
        if (matcher.isAny()) {
            return true;
        }
        return matcher.test(driver.getBlock(x, y, z));
    }

    private static void actuallyGenerateStuff(LostCityTerrainFeature feature, BuildingInfo info, StuffSettingsRE settings, CompiledPalette palette, boolean inBuilding) {
        ChunkDriver driver = feature.driver;
        WorldGenLevel level = info.provider.getWorld();
        int attempts = settings.getAttempts();
        Integer minheight = settings.getMinheight();
        Integer maxheight = settings.getMaxheight();
        if (minheight == null) {
            minheight = info.groundLevel;
            if (inBuilding && info.hasBuilding) {
                int lowestLevel = info.getCityGroundLevel() - info.cellars * 6;
                minheight = lowestLevel;
            }
        }
        if (maxheight == null) {
            maxheight = minheight + 20;
            if (inBuilding && info.hasBuilding) {
                maxheight = info.getCityGroundLevel() + info.getNumFloors() * 6 + 10;
            }
        }
        int mincount = settings.getMincount();
        int maxcount = settings.getMaxcount();
        RandomSource rand = feature.rand;
        int count = rand.nextInt(maxcount - mincount) + mincount;
        block0: for (int j = 0; j < count; ++j) {
            for (int i = 0; i < attempts; ++i) {
                int k;
                Boolean isSeesky;
                int x = rand.nextInt(16);
                int y = rand.nextInt(maxheight - minheight) + minheight;
                int z = rand.nextInt(16);
                String blocks = settings.getColumn();
                if (!Stuff.testBlock(driver, settings.getBlockMatcher(), x, y - 1, z) || !Stuff.testBlock(driver, settings.getUpperBlockMatcher(), x, y + blocks.length(), z) || (isSeesky = settings.isSeesky()) != null && isSeesky.booleanValue() != level.canSeeSky(info.getRelativePos(x, y, z))) continue;
                boolean ok = true;
                for (k = 0; k < blocks.length(); ++k) {
                    if (driver.getBlock(x, y + k, z) == feature.air) continue;
                    ok = false;
                    break;
                }
                if (!ok) continue;
                driver.current(x, y, z);
                for (k = 0; k < blocks.length(); ++k) {
                    BlockState block = palette.get(blocks.charAt(k));
                    driver.add(block);
                }
                continue block0;
            }
        }
    }
}

