/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost;

import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.RailShape;

public enum Transform {
    ROTATE_NONE(Rotation.NONE),
    ROTATE_90(Rotation.CLOCKWISE_90),
    ROTATE_180(Rotation.CLOCKWISE_180),
    ROTATE_270(Rotation.COUNTERCLOCKWISE_90),
    MIRROR_X(Rotation.CLOCKWISE_180),
    MIRROR_Z(Rotation.CLOCKWISE_180),
    MIRROR_90_X(Rotation.CLOCKWISE_90);

    private final Rotation mcRotation;

    private Transform(Rotation mcRotation) {
        this.mcRotation = mcRotation;
    }

    public Rotation getMcRotation() {
        return this.mcRotation;
    }

    public static Transform randomRotation() {
        return switch ((int)(Math.random() * 4.0)) {
            case 0 -> ROTATE_NONE;
            case 1 -> ROTATE_90;
            case 2 -> ROTATE_180;
            case 3 -> ROTATE_270;
            default -> ROTATE_NONE;
        };
    }

    public Transform getOpposite() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ROTATE_NONE;
            case 3 -> ROTATE_90;
            case 2 -> ROTATE_180;
            case 1 -> ROTATE_270;
            case 4 -> MIRROR_X;
            case 5 -> MIRROR_Z;
            case 6 -> MIRROR_90_X;
        };
    }

    public int rotateX(int x, int z) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> x;
            case 1 -> 15 - z;
            case 2 -> 15 - x;
            case 3 -> z;
            case 4 -> 15 - x;
            case 5 -> x;
            case 6 -> z;
        };
    }

    public int rotateZ(int x, int z) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> z;
            case 1 -> x;
            case 2 -> 15 - z;
            case 3 -> 15 - x;
            case 4 -> z;
            case 5 -> 15 - z;
            case 6 -> x;
        };
    }

    public RailShape transform(RailShape shape) {
        if (this == ROTATE_NONE) {
            return shape;
        }
        switch (shape) {
            case NORTH_SOUTH: {
                return this == ROTATE_90 || this == ROTATE_270 || this == MIRROR_90_X ? RailShape.EAST_WEST : shape;
            }
            case EAST_WEST: {
                return this == ROTATE_90 || this == ROTATE_270 ? RailShape.NORTH_SOUTH : shape;
            }
            case ASCENDING_EAST: {
                switch (this.ordinal()) {
                    case 1: {
                        return RailShape.ASCENDING_SOUTH;
                    }
                    case 6: {
                        return RailShape.ASCENDING_NORTH;
                    }
                    case 2: {
                        return RailShape.ASCENDING_WEST;
                    }
                    case 3: {
                        return RailShape.ASCENDING_NORTH;
                    }
                    case 4: {
                        return RailShape.ASCENDING_WEST;
                    }
                }
                break;
            }
            case ASCENDING_WEST: {
                switch (this.ordinal()) {
                    case 1: {
                        return RailShape.ASCENDING_NORTH;
                    }
                    case 6: {
                        return RailShape.ASCENDING_SOUTH;
                    }
                    case 2: {
                        return RailShape.ASCENDING_EAST;
                    }
                    case 3: {
                        return RailShape.ASCENDING_SOUTH;
                    }
                    case 4: {
                        return RailShape.ASCENDING_EAST;
                    }
                }
                break;
            }
            case ASCENDING_NORTH: {
                switch (this.ordinal()) {
                    case 1: {
                        return RailShape.ASCENDING_EAST;
                    }
                    case 6: {
                        return RailShape.ASCENDING_WEST;
                    }
                    case 2: {
                        return RailShape.ASCENDING_SOUTH;
                    }
                    case 3: {
                        return RailShape.ASCENDING_WEST;
                    }
                    case 4: {
                        return RailShape.ASCENDING_SOUTH;
                    }
                    case 5: {
                        return RailShape.ASCENDING_SOUTH;
                    }
                }
                break;
            }
            case ASCENDING_SOUTH: {
                switch (this.ordinal()) {
                    case 1: {
                        return RailShape.ASCENDING_WEST;
                    }
                    case 6: {
                        return RailShape.ASCENDING_EAST;
                    }
                    case 2: {
                        return RailShape.ASCENDING_NORTH;
                    }
                    case 3: {
                        return RailShape.ASCENDING_EAST;
                    }
                    case 4: {
                        return RailShape.ASCENDING_NORTH;
                    }
                    case 5: {
                        return RailShape.ASCENDING_NORTH;
                    }
                }
                break;
            }
            case SOUTH_EAST: {
                switch (this.ordinal()) {
                    case 1: {
                        return RailShape.SOUTH_WEST;
                    }
                    case 6: {
                        return RailShape.NORTH_EAST;
                    }
                    case 2: {
                        return RailShape.NORTH_WEST;
                    }
                    case 3: {
                        return RailShape.NORTH_EAST;
                    }
                    case 4: {
                        return RailShape.SOUTH_WEST;
                    }
                    case 5: {
                        return RailShape.NORTH_EAST;
                    }
                }
                break;
            }
            case SOUTH_WEST: {
                switch (this.ordinal()) {
                    case 1: {
                        return RailShape.NORTH_WEST;
                    }
                    case 6: {
                        return RailShape.SOUTH_EAST;
                    }
                    case 2: {
                        return RailShape.NORTH_EAST;
                    }
                    case 3: {
                        return RailShape.SOUTH_EAST;
                    }
                    case 4: {
                        return RailShape.SOUTH_EAST;
                    }
                    case 5: {
                        return RailShape.NORTH_WEST;
                    }
                }
                break;
            }
            case NORTH_WEST: {
                switch (this.ordinal()) {
                    case 1: {
                        return RailShape.NORTH_EAST;
                    }
                    case 6: {
                        return RailShape.SOUTH_WEST;
                    }
                    case 2: {
                        return RailShape.SOUTH_EAST;
                    }
                    case 3: {
                        return RailShape.SOUTH_WEST;
                    }
                    case 4: {
                        return RailShape.NORTH_EAST;
                    }
                    case 5: {
                        return RailShape.SOUTH_WEST;
                    }
                }
                break;
            }
            case NORTH_EAST: {
                switch (this.ordinal()) {
                    case 1: {
                        return RailShape.SOUTH_EAST;
                    }
                    case 6: {
                        return RailShape.NORTH_WEST;
                    }
                    case 2: {
                        return RailShape.SOUTH_WEST;
                    }
                    case 3: {
                        return RailShape.NORTH_WEST;
                    }
                    case 4: {
                        return RailShape.NORTH_WEST;
                    }
                    case 5: {
                        return RailShape.SOUTH_EAST;
                    }
                }
            }
        }
        throw new IllegalStateException("Cannot happen!");
    }
}

