/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.commands;

import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Flags;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.MultiversePortals;
import org.mvplugins.multiverse.portals.commands.PortalsCommand;
import org.mvplugins.multiverse.portals.config.PortalsConfig;

@Service
class SelectCommand
extends PortalsCommand {
    private final MultiversePortals plugin;
    private final PortalsConfig portalsConfig;

    @Inject
    SelectCommand(@NotNull MultiversePortals plugin, @NotNull PortalsConfig portalsConfig) {
        this.plugin = plugin;
        this.portalsConfig = portalsConfig;
    }

    @Subcommand(value="select")
    @CommandPermission(value="multiverse.portal.select,multiverse.portal.create")
    @CommandCompletion(value="@mvportals")
    @Syntax(value="<portal>")
    @Description(value="Selects a portal so you can perform multiple modifications on it.")
    void onSelectCommand(@Flags(value="resolve=issuerOnly") Player player, @Optional @Syntax(value="<portal>") @Description(value="The portal to select") MVPortal portal) {
        if (portal == null) {
            MVPortal selected = this.plugin.getPortalSession(player).getSelectedPortal();
            if (this.plugin.getPortalSession(player).getSelectedPortal() == null) {
                player.sendMessage("You have not selected a portal yet!");
                player.sendMessage("Use a " + String.valueOf(ChatColor.GREEN) + String.valueOf(this.portalsConfig.getWandMaterial()) + String.valueOf(ChatColor.WHITE) + " to do so!");
                return;
            }
            player.sendMessage("You have selected: " + String.valueOf(ChatColor.DARK_AQUA) + selected.getName());
            return;
        }
        this.plugin.getPortalSession(player).selectPortal(portal);
        player.sendMessage("Portal: " + String.valueOf(ChatColor.DARK_AQUA) + portal.getName() + String.valueOf(ChatColor.WHITE) + " has been selected.");
    }

    @Service
    private static final class LegacyAlias
    extends SelectCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(MultiversePortals plugin, PortalsConfig portalsConfig) {
            super(plugin, portalsConfig);
        }

        @Override
        @CommandAlias(value="mvpselect|mvps")
        void onSelectCommand(Player player, MVPortal portal) {
            super.onSelectCommand(player, portal);
        }
    }
}

