/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.commands;

import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Flags;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Single;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.portals.MultiversePortals;
import org.mvplugins.multiverse.portals.WorldEditConnection;
import org.mvplugins.multiverse.portals.commands.PortalsCommand;
import org.mvplugins.multiverse.portals.config.PortalsConfig;

@Service
class WandCommand
extends PortalsCommand {
    private final MultiversePortals plugin;
    private final PortalsConfig portalsConfig;

    @Inject
    WandCommand(@NotNull MultiversePortals plugin, @NotNull PortalsConfig portalsConfig) {
        this.plugin = plugin;
        this.portalsConfig = portalsConfig;
    }

    @Subcommand(value="wand")
    @CommandPermission(value="multiverse.portal.givewand")
    @CommandCompletion(value="enable|disable|toggle")
    @Syntax(value="[enable|disable|toggle]")
    @Description(value="Gives you the wand that MV uses. This will only work if you are NOT using WorldEdit.")
    void onWandCommand(@Flags(value="resolve=issuerOnly") Player player, @Optional @Single @Syntax(value="[enable|disable|toggle]") @Description(value="Enable, disable, or toggle the wand.") String action) {
        if (action != null) {
            if (action.equals("enable")) {
                this.plugin.setWandEnabled(true);
            } else if (action.equals("disable")) {
                this.plugin.setWandEnabled(false);
            } else if (action.equals("toggle")) {
                this.plugin.setWandEnabled(!this.plugin.isWandEnabled());
            } else {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You must specify one of 'enable,' 'disable,' or 'toggle!'");
            }
            return;
        }
        WorldEditConnection worldEdit = this.plugin.getWorldEditConnection();
        if (worldEdit != null && worldEdit.isConnected()) {
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Cool!" + String.valueOf(ChatColor.WHITE) + " You're using" + String.valueOf(ChatColor.AQUA) + " WorldEdit! ");
            player.sendMessage("Just use " + String.valueOf(ChatColor.GOLD) + "the WorldEdit wand " + String.valueOf(ChatColor.WHITE) + "to perform portal selections!");
            return;
        }
        ItemStack wand = new ItemStack(this.portalsConfig.getWandMaterial(), 1);
        if (player.getInventory().getItemInMainHand().getAmount() == 0) {
            player.getInventory().setItemInMainHand(wand);
            player.sendMessage("You have been given a " + String.valueOf(ChatColor.GREEN) + "Multiverse Portal Wand(" + String.valueOf(wand.getType()) + ")!");
        } else if (player.getInventory().addItem(new ItemStack[]{wand}).isEmpty()) {
            player.sendMessage("A " + String.valueOf(ChatColor.GREEN) + "Multiverse Portal Wand(" + String.valueOf(wand.getType()) + ")" + String.valueOf(ChatColor.WHITE) + " has been placed in your inventory.");
        } else {
            player.sendMessage("Your Inventory is full. A " + String.valueOf(ChatColor.GREEN) + "Multiverse Portal Wand(" + String.valueOf(wand.getType()) + ")" + String.valueOf(ChatColor.WHITE) + " has been placed dropped nearby.");
            player.getWorld().dropItemNaturally(player.getLocation(), wand);
        }
    }

    @Service
    private static final class LegacyAlias
    extends WandCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(MultiversePortals plugin, PortalsConfig portalsConfig) {
            super(plugin, portalsConfig);
        }

        @Override
        @CommandAlias(value="mvpwand|mvpw")
        void onWandCommand(Player player, String action) {
            super.onWandCommand(player, action);
        }
    }
}

