/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.destination;

import java.util.Collection;
import org.bukkit.command.CommandSender;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.destination.Destination;
import org.mvplugins.multiverse.core.destination.DestinationSuggestionPacket;
import org.mvplugins.multiverse.core.locale.MVCorei18n;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.teleportation.LocationManipulation;
import org.mvplugins.multiverse.core.utils.result.Attempt;
import org.mvplugins.multiverse.core.utils.result.FailureReason;
import org.mvplugins.multiverse.external.acf.locales.MessageKey;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.destination.PortalDestinationInstance;
import org.mvplugins.multiverse.portals.utils.PortalManager;

@Service
public class PortalDestination
implements Destination<PortalDestination, PortalDestinationInstance, InstanceFailureReason> {
    private final PortalManager portalManager;
    private final LocationManipulation locationManipulation;

    @Inject
    PortalDestination(@NotNull PortalManager portalManager, @NotNull LocationManipulation locationManipulation) {
        this.portalManager = portalManager;
        this.locationManipulation = locationManipulation;
    }

    @NotNull
    public String getIdentifier() {
        return "p";
    }

    @NotNull
    public Attempt<PortalDestinationInstance, InstanceFailureReason> getDestinationInstance(@Nullable String destinationParams) {
        String[] items = destinationParams.split(":");
        if (items.length > 3) {
            return Attempt.failure((FailureReason)InstanceFailureReason.INVALID_FORMAT, (Message)Message.of((String)"Invalid format! Expected format is: p:portalName:[direction]", (MessageReplacement[])new MessageReplacement[0]));
        }
        String portalName = items[0];
        MVPortal portal = this.portalManager.getPortal(portalName);
        if (portal == null) {
            return Attempt.failure((FailureReason)InstanceFailureReason.PORTAL_NOT_FOUND, (Message)Message.of((String)("Portal '" + portalName + "' does not exist!"), (MessageReplacement[])new MessageReplacement[0]));
        }
        String direction = items.length == 2 ? items[1] : null;
        float yaw = direction != null ? this.locationManipulation.getYaw(direction) : -1.0f;
        return Attempt.success((Object)((Object)new PortalDestinationInstance(this, portal, direction, yaw)));
    }

    @NotNull
    public Collection<DestinationSuggestionPacket> suggestDestinations(@NotNull CommandSender sender, @Nullable String s) {
        return this.portalManager.getAllPortals().stream().map(p -> new DestinationSuggestionPacket((Destination)this, p.getName(), p.getName())).toList();
    }

    public static enum InstanceFailureReason implements FailureReason
    {
        INVALID_FORMAT((MessageKeyProvider)MVCorei18n.GENERIC_FAILURE),
        PORTAL_NOT_FOUND((MessageKeyProvider)MVCorei18n.GENERIC_FAILURE);

        private final MessageKeyProvider messageKey;

        private InstanceFailureReason(MessageKeyProvider message) {
            this.messageKey = message;
        }

        public MessageKey getMessageKey() {
            return this.messageKey.getMessageKey();
        }
    }
}

