/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals;

import java.lang.annotation.Annotation;
import java.util.Date;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.mvplugins.multiverse.core.economy.MVEconomist;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.MultiversePortals;
import org.mvplugins.multiverse.portals.WorldEditConnection;
import org.mvplugins.multiverse.portals.config.PortalsConfig;
import org.mvplugins.multiverse.portals.enums.MoveType;
import org.mvplugins.multiverse.portals.util.MVPLogging;
import org.mvplugins.multiverse.portals.utils.DisplayUtils;
import org.mvplugins.multiverse.portals.utils.MultiverseRegion;
import org.mvplugins.multiverse.portals.utils.PortalManager;

public class PortalPlayerSession {
    private final MultiversePortals plugin;
    private final PortalsConfig portalsConfig;
    private final PortalManager portalManager;
    private final WorldManager worldManager;
    private final DisplayUtils displayUtils;
    private final MVEconomist economist;
    private final Player player;
    private MVPortal portalSelection = null;
    private MVPortal standingIn = null;
    private boolean debugMode = false;
    private boolean staleLocation;
    private boolean hasMovedOutOfPortal = true;
    private Location loc;
    private Vector rightClick;
    private Vector leftClick;
    private LoadedMultiverseWorld rightClickWorld;
    private LoadedMultiverseWorld leftClickWorld;
    private Date lastTeleportTime;

    public PortalPlayerSession(MultiversePortals plugin, Player p) {
        this.plugin = plugin;
        this.portalsConfig = (PortalsConfig)plugin.getServiceLocator().getService(PortalsConfig.class, new Annotation[0]);
        this.portalManager = (PortalManager)plugin.getServiceLocator().getService(PortalManager.class, new Annotation[0]);
        this.worldManager = (WorldManager)plugin.getServiceLocator().getService(WorldManager.class, new Annotation[0]);
        this.displayUtils = (DisplayUtils)plugin.getServiceLocator().getService(DisplayUtils.class, new Annotation[0]);
        this.economist = (MVEconomist)plugin.getServiceLocator().getService(MVEconomist.class, new Annotation[0]);
        this.player = p;
        this.setLocation(p.getLocation());
        this.lastTeleportTime = new Date(new Date().getTime() - (long)this.portalsConfig.getPortalCooldown());
    }

    public boolean selectPortal(MVPortal portal) {
        this.portalSelection = portal;
        return true;
    }

    public MVPortal getSelectedPortal() {
        return this.portalSelection;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
        if (this.debugMode) {
            this.player.sendMessage("Portal debug mode " + String.valueOf(ChatColor.GREEN) + "ENABLED");
            this.player.sendMessage("Use " + String.valueOf(ChatColor.DARK_AQUA) + "/mvp debug" + String.valueOf(ChatColor.WHITE) + " to disable.");
        } else {
            this.player.sendMessage("Portal debug mode " + String.valueOf(ChatColor.RED) + "DISABLED");
        }
    }

    public boolean isDebugModeOn() {
        return this.debugMode;
    }

    public void setStaleLocation(boolean active) {
        this.staleLocation = active;
    }

    public boolean isStaleLocation() {
        return this.staleLocation;
    }

    private void setLocation(Location loc) {
        this.loc = loc;
        this.setStandingInLocation();
    }

    private void setStandingInLocation() {
        if (this.standingIn == null && this.portalManager.isPortal(this.loc)) {
            this.standingIn = this.portalManager.getPortal(this.loc);
        } else if (!this.portalManager.isPortal(this.loc)) {
            this.hasMovedOutOfPortal = true;
            this.standingIn = null;
        } else {
            this.hasMovedOutOfPortal = false;
        }
    }

    public boolean doTeleportPlayer(MoveType eventType) {
        if (eventType == MoveType.PLAYER_MOVE && this.player.isInsideVehicle()) {
            return false;
        }
        return this.hasMovedOutOfPortal && this.standingIn != null;
    }

    public Location getLocation() {
        return this.loc;
    }

    public void setStaleLocation(Location loc, MoveType moveType) {
        if (this.player == null) {
            return;
        }
        if (this.player.isInsideVehicle() && moveType != MoveType.VEHICLE_MOVE) {
            return;
        }
        if (this.getLocation().getBlockX() == loc.getBlockX() && this.getLocation().getBlockY() == loc.getBlockY() && this.getLocation().getBlockZ() == loc.getBlockZ()) {
            this.setStaleLocation(true);
        } else {
            this.setLocation(loc);
            this.setStaleLocation(false);
        }
    }

    public boolean setLeftClickSelection(Vector v, LoadedMultiverseWorld world) {
        if (!this.plugin.isWandEnabled()) {
            return false;
        }
        this.leftClick = v;
        this.leftClickWorld = world;
        String message = String.valueOf(ChatColor.AQUA) + "First position set to: (" + v.getBlockX() + ", " + v.getBlockY() + ", " + v.getBlockZ() + ")";
        if (this.leftClickWorld == this.rightClickWorld && this.rightClick != null) {
            MultiverseRegion tempReg = new MultiverseRegion(this.leftClick, this.rightClick, this.leftClickWorld);
            message = message + String.valueOf(ChatColor.GOLD) + " (" + tempReg.getArea() + " blocks)";
        }
        this.player.sendMessage(message);
        return true;
    }

    public boolean setRightClickSelection(Vector v, LoadedMultiverseWorld world) {
        if (!this.plugin.isWandEnabled()) {
            return false;
        }
        this.rightClick = v;
        this.rightClickWorld = world;
        String message = String.valueOf(ChatColor.AQUA) + "Second position set to: (" + v.getBlockX() + ", " + v.getBlockY() + ", " + v.getBlockZ() + ")";
        if (this.leftClickWorld == this.rightClickWorld && this.leftClick != null) {
            MultiverseRegion tempReg = new MultiverseRegion(this.leftClick, this.rightClick, this.leftClickWorld);
            message = message + String.valueOf(ChatColor.GOLD) + " (" + tempReg.getArea() + " blocks)";
        }
        this.player.sendMessage(message);
        return true;
    }

    public MultiverseRegion getSelectedRegion() {
        WorldEditConnection worldEdit = this.plugin.getWorldEditConnection();
        if (worldEdit != null && worldEdit.isConnected()) {
            if (worldEdit.isSelectionAvailable(this.player)) {
                Location minPoint = worldEdit.getSelectionMinPoint(this.player);
                Location maxPoint = worldEdit.getSelectionMaxPoint(this.player);
                if (minPoint != null && maxPoint != null && minPoint.getWorld().equals((Object)maxPoint.getWorld())) {
                    return new MultiverseRegion(minPoint, maxPoint, (LoadedMultiverseWorld)this.worldManager.getLoadedWorld(minPoint.getWorld().getName()).getOrNull());
                }
                this.player.sendMessage("You haven't finished your selection.");
                return null;
            }
            this.player.sendMessage("You must have a WorldEdit selection to do this.");
            return null;
        }
        if (this.leftClick == null) {
            this.player.sendMessage("You need to LEFT click on a block with your wand!");
            return null;
        }
        if (this.rightClick == null) {
            this.player.sendMessage("You need to RIGHT click on a block with your wand!");
            return null;
        }
        if (!this.leftClickWorld.equals(this.rightClickWorld)) {
            this.player.sendMessage("You need to select both coords in the same world!");
            this.player.sendMessage("Left Click Position was in:" + this.leftClickWorld.getAlias());
            this.player.sendMessage("Right Click Position was in:" + this.rightClickWorld.getAlias());
            return null;
        }
        return new MultiverseRegion(this.leftClick, this.rightClick, this.leftClickWorld);
    }

    public MVPortal getStandingInPortal() {
        return this.standingIn;
    }

    public MVPortal getUncachedStandingInPortal() {
        this.standingIn = this.portalManager.getPortal(this.loc);
        return this.standingIn;
    }

    public void playerDidTeleport(Location location) {
        if (this.portalManager.getPortal(location) != null) {
            this.hasMovedOutOfPortal = false;
            return;
        }
        this.hasMovedOutOfPortal = true;
    }

    public boolean hasMovedOutOfPortal() {
        return this.hasMovedOutOfPortal;
    }

    public boolean showDebugInfo() {
        if (!this.isDebugModeOn()) {
            return false;
        }
        if (this.standingIn == null) {
            return false;
        }
        this.displayUtils.showStaticInfo((CommandSender)this.player, this.standingIn, "You are currently standing in ");
        this.displayUtils.showPortalPriceInfo(this.standingIn, (CommandSender)this.player);
        return true;
    }

    public boolean showDebugInfo(MVPortal portal) {
        if (portal.playerCanEnterPortal(this.player)) {
            this.displayUtils.showStaticInfo((CommandSender)this.player, portal, "Portal Info ");
            this.displayUtils.showPortalPriceInfo(portal, (CommandSender)this.player);
        } else {
            MVPLogging.info("Player " + this.player.getName() + " walked through" + portal.getName() + " with debug on.", new Object[0]);
        }
        return true;
    }

    public void setTeleportTime(Date date) {
        this.lastTeleportTime = date;
    }

    public boolean checkAndSendCooldownMessage() {
        long cooldownMs = this.getRemainingTeleportCooldown();
        if (cooldownMs > 0L) {
            this.player.sendMessage(this.getCooldownMessage(cooldownMs));
            return true;
        }
        return false;
    }

    private long getRemainingTeleportCooldown() {
        long cooldownEndMs = this.lastTeleportTime.getTime() + (long)this.portalsConfig.getPortalCooldown();
        long timeMs = new Date().getTime();
        return cooldownEndMs - timeMs;
    }

    private String getCooldownMessage(long cooldownMs) {
        return "There is a portal " + String.valueOf(ChatColor.AQUA) + "cooldown " + String.valueOf(ChatColor.WHITE) + "in effect. Please try again in " + String.valueOf(ChatColor.GOLD) + this.formatCooldownTime(cooldownMs) + String.valueOf(ChatColor.WHITE) + ".";
    }

    private String formatCooldownTime(long cooldownMs) {
        if (cooldownMs < 1000L) {
            return "1s";
        }
        return cooldownMs / 1000L + "s";
    }
}

