/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.listeners;

import java.util.Date;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.teleportation.AsyncSafetyTeleporter;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.portals.PortalPlayerSession;
import org.mvplugins.multiverse.portals.util.MVPLogging;

@Service
final class PlayerListenerHelper {
    private final AsyncSafetyTeleporter safetyTeleporter;

    @Inject
    PlayerListenerHelper(@NotNull AsyncSafetyTeleporter safetyTeleporter) {
        this.safetyTeleporter = safetyTeleporter;
    }

    void stateSuccess(String playerName, String worldName) {
        MVPLogging.fine(String.format("MV-Portals is allowing Player '%s' to use the portal '%s'.", playerName, worldName), new Object[0]);
    }

    void stateFailure(String playerName, String portalName) {
        MVPLogging.fine(String.format("MV-Portals is DENYING Player '%s' access to use the portal '%s'.", playerName, portalName), new Object[0]);
    }

    void performTeleport(Player player, Location to, PortalPlayerSession ps, DestinationInstance<?, ?> destination, boolean checkSafety) {
        this.safetyTeleporter.to(destination).checkSafety(checkSafety && destination.checkTeleportSafety()).teleportSingle((Entity)player).onSuccess(() -> {
            ps.playerDidTeleport(to);
            ps.setTeleportTime(new Date());
            this.stateSuccess(player.getDisplayName(), destination.toString());
        }).onFailure(reason -> MVPLogging.fine("Failed to teleport player '%s' to destination '%s'. Reason: %s", player.getDisplayName(), destination, reason));
    }
}

