/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.utils;

import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.economy.MVEconomist;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.portals.MVPortal;

@Service
public class DisplayUtils {
    private final WorldManager worldManager;
    private final MVEconomist economist;

    @Inject
    DisplayUtils(@NotNull WorldManager worldManager, @NotNull MVEconomist economist) {
        this.worldManager = worldManager;
        this.economist = economist;
    }

    public void showStaticInfo(CommandSender sender, MVPortal portal, String message) {
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "--- " + message + String.valueOf(ChatColor.DARK_AQUA) + portal.getName() + String.valueOf(ChatColor.AQUA) + " ---");
        String[] locParts = portal.getPortalLocation().toString().split(":");
        sender.sendMessage("Coords: " + String.valueOf(ChatColor.GOLD) + locParts[0] + String.valueOf(ChatColor.WHITE) + " to " + String.valueOf(ChatColor.GOLD) + locParts[1] + String.valueOf(ChatColor.WHITE) + " in " + String.valueOf(ChatColor.GOLD) + portal.getWorld().getName());
        if (portal.getDestination() == null) {
            sender.sendMessage("Destination: " + String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.ITALIC) + "NOT SET!");
        } else {
            MultiverseWorld destWorld;
            Object destination = portal.getDestination().toString();
            String destType = portal.getDestination().getIdentifier();
            if (destType.equals("w") && (destWorld = (MultiverseWorld)this.worldManager.getWorld((String)destination).getOrNull()) != null) {
                destination = "(World) " + String.valueOf(ChatColor.DARK_AQUA) + (String)destination;
            }
            if (destType.equals("p")) {
                // empty if block
            }
            if (destType.equals("e")) {
                int z;
                int y;
                int x;
                String destinationWorld = portal.getDestination().toString().split(":")[1];
                String destPart = portal.getDestination().toString().split(":")[2];
                String[] targetParts = destPart.split(",");
                try {
                    x = (int)Double.parseDouble(targetParts[0]);
                    y = (int)Double.parseDouble(targetParts[1]);
                    z = (int)Double.parseDouble(targetParts[2]);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    return;
                }
                destination = "(Location) " + String.valueOf(ChatColor.DARK_AQUA) + destinationWorld + ", " + x + ", " + y + ", " + z;
            }
            if (destType.equals("i")) {
                destination = String.valueOf(ChatColor.RED) + "Invalid Destination!";
            }
            sender.sendMessage("Destination: " + String.valueOf(ChatColor.GOLD) + (String)destination);
        }
    }

    public void showPortalPriceInfo(MVPortal portal, CommandSender sender) {
        if (portal.getPrice() > 0.0) {
            sender.sendMessage("Price: " + String.valueOf(ChatColor.GREEN) + this.economist.formatPrice(portal.getPrice(), portal.getCurrency()));
        } else if (portal.getPrice() < 0.0) {
            sender.sendMessage("Price: " + String.valueOf(ChatColor.GREEN) + this.economist.formatPrice(-portal.getPrice(), portal.getCurrency()));
        } else {
            sender.sendMessage("Price: " + String.valueOf(ChatColor.GREEN) + "FREE!");
        }
    }
}

