/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.utils;

import org.bukkit.Axis;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Orientable;
import org.bukkit.entity.Player;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.teleportation.LocationManipulation;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.util.MVPLogging;
import org.mvplugins.multiverse.portals.utils.MultiverseRegion;

@Service
public class PortalFiller {
    private final LocationManipulation locationManipulation;

    @Inject
    PortalFiller(@NotNull LocationManipulation locationManipulation) {
        this.locationManipulation = locationManipulation;
    }

    public boolean fillRegion(MultiverseRegion r, Location l, Material type, Player player) {
        if (r.getWidth() != 1 && r.getDepth() != 1) {
            player.sendMessage("Cannot fill portal, It needs a width or depth of " + String.valueOf(ChatColor.GOLD) + "1" + String.valueOf(ChatColor.WHITE) + ". w:[" + String.valueOf(ChatColor.AQUA) + r.getWidth() + String.valueOf(ChatColor.WHITE) + "] d:[" + String.valueOf(ChatColor.AQUA) + r.getDepth() + String.valueOf(ChatColor.WHITE) + "]");
        }
        return this.fillRegion(r, l, type);
    }

    public boolean fillRegion(MultiverseRegion r, Location l, Material type) {
        if (r.getWidth() != 1 && r.getDepth() != 1) {
            MVPLogging.finer("Cannot fill portal, it is too big... w:[" + r.getWidth() + "] d:[" + r.getDepth() + "]", new Object[0]);
            return false;
        }
        MVPLogging.finer("Neat, Starting Portal fill w:[" + r.getWidth() + "] h:[" + r.getHeight() + "] d:[" + r.getDepth() + "]", new Object[0]);
        int useX = r.getWidth() == 1 ? 0 : 1;
        int useZ = r.getDepth() == 1 ? 0 : 1;
        Block oldLoc = l.getWorld().getBlockAt(l);
        MVPLogging.finer("Filling: " + String.valueOf(type), new Object[0]);
        this.doFill(oldLoc, useX, useZ, r, type);
        return true;
    }

    private void doFill(Block newLoc, int useX, int useZ, MultiverseRegion r, Material type) {
        if (this.isValidPortalRegion(newLoc.getLocation(), type)) {
            if (type == Material.NETHER_PORTAL) {
                boolean usePhysics = false;
                newLoc.setType(type, usePhysics);
                if (useX == 0) {
                    Orientable b = (Orientable)newLoc.getBlockData();
                    b.setAxis(Axis.Z);
                    newLoc.setBlockData((BlockData)b, usePhysics);
                }
            } else {
                newLoc.setType(type);
            }
        }
        if (this.isValidPortalRegion(newLoc.getRelative(useX * 1, 0, useZ * 1).getLocation(), type)) {
            Block tmpLoc = newLoc.getRelative(useX * 1, 0, useZ * 1);
            if (!r.containsVector(tmpLoc.getLocation())) {
                return;
            }
            MVPLogging.finest("Moving Right/Left: " + this.locationManipulation.strCoordsRaw(tmpLoc.getLocation()), new Object[0]);
            this.doFill(tmpLoc, useX, useZ, r, type);
        }
        if (this.isValidPortalRegion(newLoc.getRelative(useX * 0, 1, useZ * 0).getLocation(), type)) {
            Block tmpLoc = newLoc.getRelative(useX * 0, 1, useZ * 0);
            if (!r.containsVector(tmpLoc.getLocation())) {
                return;
            }
            MVPLogging.finest("Moving Up" + this.locationManipulation.strCoordsRaw(tmpLoc.getLocation()), new Object[0]);
            this.doFill(tmpLoc, useX, useZ, r, type);
        }
        if (this.isValidPortalRegion(newLoc.getRelative(useX * -1, 0, useZ * -1).getLocation(), type)) {
            Block tmpLoc = newLoc.getRelative(useX * -1, 0, useZ * -1);
            if (!r.containsVector(tmpLoc.getLocation())) {
                return;
            }
            MVPLogging.finest("Moving Left/Right" + this.locationManipulation.strCoordsRaw(tmpLoc.getLocation()), new Object[0]);
            this.doFill(tmpLoc, useX, useZ, r, type);
        }
        if (this.isValidPortalRegion(newLoc.getRelative(useX * 0, -1, useZ * 0).getLocation(), type)) {
            Block tmpLoc = newLoc.getRelative(useX * 0, -1, useZ * 0);
            if (!r.containsVector(tmpLoc.getLocation())) {
                return;
            }
            MVPLogging.finest("Moving Down" + this.locationManipulation.strCoordsRaw(tmpLoc.getLocation()), new Object[0]);
            this.doFill(tmpLoc, useX, useZ, r, type);
        }
    }

    private boolean isValidPortalRegion(Location l, Material portalType) {
        Material type = l.getBlock().getType();
        if (l.getWorld().getBlockAt(l).getType() == portalType) {
            return false;
        }
        return MVPortal.isPortalInterior(type);
    }
}

