/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.end_plus.init;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.end_plus.EndPlusMod;
import net.mcreator.end_plus.init.EndPlusModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EndPlusModVillagerProfessions {
    private static final Map<String, ProfessionPoiType> POI_TYPES = new HashMap<String, ProfessionPoiType>();
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PROFESSIONS, (String)"end_plus");
    public static final RegistryObject<VillagerProfession> ENDER = EndPlusModVillagerProfessions.registerProfession("ender", () -> (Block)EndPlusModBlocks.ENDER_TRADER.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_armorer")));

    private static RegistryObject<VillagerProfession> registerProfession(String name, Supplier<Block> block, Supplier<SoundEvent> soundEvent) {
        POI_TYPES.put(name, new ProfessionPoiType(block, null));
        return PROFESSIONS.register(name, () -> {
            PointOfInterestType poiPredicate = EndPlusModVillagerProfessions.POI_TYPES.get((Object)name).poiType;
            return new VillagerProfession("end_plus:" + name, poiPredicate, ImmutableSet.of(), ImmutableSet.of(), (SoundEvent)soundEvent.get());
        });
    }

    @SubscribeEvent
    public static void registerProfessionPointsOfInterest(RegistryEvent.Register<PointOfInterestType> event) {
        for (Map.Entry<String, ProfessionPoiType> entry : POI_TYPES.entrySet()) {
            Block block = entry.getValue().block.get();
            String name = entry.getKey();
            Optional existingCheck = PointOfInterestType.func_221047_b((BlockState)block.func_176223_P());
            if (existingCheck.isPresent()) {
                EndPlusMod.LOGGER.error("Skipping villager profession " + name + " that uses POI block " + block + " that is already in use by " + existingCheck);
                continue;
            }
            PointOfInterestType poiType = (PointOfInterestType)new PointOfInterestType(name, (Set)ImmutableSet.copyOf((Collection)block.func_176194_O().func_177619_a()), 1, 1).setRegistryName("end_plus:" + name);
            PointOfInterestType.func_221052_a((PointOfInterestType)poiType);
            event.getRegistry().register((IForgeRegistryEntry)poiType);
            entry.getValue().poiType = poiType;
        }
    }

    private static class ProfessionPoiType {
        final Supplier<Block> block;
        PointOfInterestType poiType;

        ProfessionPoiType(Supplier<Block> block, PointOfInterestType poiType) {
            this.block = block;
            this.poiType = poiType;
        }
    }
}

