/*
 * Decompiled with CFR 0.152.
 */
package net.caseykat.chess.block;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.caseykat.chess.block.custom.GamePiece;
import net.caseykat.chess.item.ModItems;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"chess");
    public static String[] COLOR = new String[]{"black", "white", "light_gray", "gray", "pink", "magenta", "purple", "blue", "light_blue", "cyan", "green", "lime", "yellow", "orange", "red", "brown"};
    public static String[] TYPE = new String[]{"pawn", "knight", "bishop", "rook", "queen", "king"};
    public static ArrayList<RegistryObject<GamePiece>> PIECES = ModBlocks.populateList();

    private static ArrayList<RegistryObject<GamePiece>> populateList() {
        ArrayList<RegistryObject<GamePiece>> list = new ArrayList<RegistryObject<GamePiece>>();
        for (String color : COLOR) {
            for (String type : TYPE) {
                DyeColor dyeColor = DyeColor.valueOf((String)color.toUpperCase());
                RegistryObject<GamePiece> block = ModBlocks.registerBlock(color + "_" + type + "_block", () -> new GamePiece(dyeColor, type));
                list.add(block);
            }
        }
        return list;
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject result = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, result);
        return result;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

