/*
 * Decompiled with CFR 0.152.
 */
package net.caseykat.chess.datagen;

import java.util.Objects;
import net.caseykat.chess.block.ModBlocks;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "chess", exFileHelper);
    }

    protected void registerStatesAndModels() {
        int i = 0;
        for (String color : ModBlocks.COLOR) {
            for (String type : ModBlocks.TYPE) {
                String id = color + "_" + type;
                this.horizontalBlock((Block)ModBlocks.PIECES.get(i).get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc(String.format("block/%s_block", id))));
                ++i;
            }
        }
    }

    private String name(Block block) {
        return this.key(block).m_135815_();
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    private void blockWithItem(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }

    private void blockItem(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockItem((Block)blockRegistryObject.get(), (ModelFile)new ModelFile.UncheckedModelFile("chess:block/" + Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get()))).m_135815_()));
    }

    private void horizontalBlockItem(RegistryObject<Block> blockRegistryObject) {
        this.horizontalBlock((Block)blockRegistryObject.get(), (ModelFile)new ModelFile.UncheckedModelFile("chess:block/" + Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get()))).m_135815_()));
    }
}

