/*
 * Decompiled with CFR 0.152.
 */
package net.caseykat.chess.datagen;

import java.util.Objects;
import net.caseykat.chess.block.ModBlocks;
import net.caseykat.chess.item.ModItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "chess", existingFileHelper);
    }

    protected void registerModels() {
        this.handheldItem(ModItems.CHESS_SET);
        for (String color : ModBlocks.COLOR) {
            for (String type : ModBlocks.TYPE) {
                String id = color + "_" + type;
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(String.format("%s:block/%s_block", "chess", id), this.modLoc(String.format("block/%s_block", type)))).texture("0", this.modLoc(String.format("block/%s_chess", color)))).texture("texture", this.modLoc(String.format("block/%s_chess", color)))).texture("particle", String.format("minecraft:block/%s_concrete", color));
                this.withExistingParent(String.format("%s:item/%s_block", "chess", id), this.modLoc(String.format("block/%s_block", id)));
            }
        }
    }

    private ItemModelBuilder simpleItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("chess", "item/" + item.getId().m_135815_()));
    }

    public void evenSimplerBlockItem(Block block) {
        this.withExistingParent("chess:" + Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_(), this.modLoc("block/" + Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_()));
    }

    private ItemModelBuilder handheldItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/handheld"))).texture("layer0", new ResourceLocation("chess", "item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder simpleBlockItem(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("chess", "item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder simpleBlockItemBlockTexture(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("chess", "block/" + item.getId().m_135815_()));
    }
}

