/*
 * Decompiled with CFR 0.152.
 */
package com.example.lagcleaner;

import com.example.lagcleaner.libs.adventure.platform.bukkit.BukkitAudiences;
import com.example.lagcleaner.libs.adventure.text.Component;
import com.example.lagcleaner.libs.adventure.text.minimessage.MiniMessage;
import com.example.lagcleaner.libs.adventure.text.minimessage.tag.resolver.Placeholder;
import com.example.lagcleaner.libs.adventure.text.minimessage.tag.resolver.TagResolver;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Monster;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LagCleaner
extends JavaPlugin {
    private FileConfiguration config;
    private FileConfiguration messagesConfig;
    private MiniMessage miniMessage;
    private BukkitAudiences adventure;
    private boolean autoCleanEnabled;
    private int autoCleanInterval;
    private boolean clearDroppedItems;
    private boolean clearMonsters;
    private boolean clearParticles;
    private List<String> excludedMonsters;
    private boolean warningsEnabled;
    private List<Integer> warningTimes;
    private BukkitRunnable autoCleanTask;

    public void onEnable() {
        this.miniMessage = MiniMessage.miniMessage();
        this.adventure = BukkitAudiences.create((Plugin)this);
        this.saveDefaultConfig();
        this.loadConfig();
        this.loadMessages();
        this.getCommand("lagclear").setExecutor((CommandExecutor)this);
        if (this.autoCleanEnabled) {
            this.startAutoClean();
        }
        this.sendMessage((CommandSender)Bukkit.getConsoleSender(), "plugin.enabled", new Object[0]);
    }

    public void onDisable() {
        if (this.autoCleanTask != null) {
            this.autoCleanTask.cancel();
        }
        if (this.adventure != null) {
            this.adventure.close();
        }
        this.sendMessage((CommandSender)Bukkit.getConsoleSender(), "plugin.disabled", new Object[0]);
    }

    private void loadConfig() {
        this.config = this.getConfig();
        this.autoCleanEnabled = this.config.getBoolean("auto-clean.enabled");
        this.autoCleanInterval = this.config.getInt("auto-clean.interval");
        this.clearDroppedItems = this.config.getBoolean("clear-options.dropped-items");
        this.clearMonsters = this.config.getBoolean("clear-options.monsters");
        this.clearParticles = this.config.getBoolean("clear-options.particles");
        this.excludedMonsters = this.config.getStringList("excluded-monsters");
        this.warningsEnabled = this.config.getBoolean("warnings.enabled");
        this.warningTimes = this.config.getIntegerList("warnings.times");
    }

    private void loadMessages() {
        File messagesFile = new File(this.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
    }

    private void sendMessage(CommandSender sender, String messageKey, Object ... placeholders) {
        String message = this.messagesConfig.getString(messageKey, "<red>Message not found: " + messageKey);
        Object component = placeholders.length > 0 ? this.miniMessage.deserialize(message, this.createTagResolvers(placeholders)) : this.miniMessage.deserialize(message);
        this.adventure.sender(sender).sendMessage((Component)component);
    }

    private void broadcastMessage(String messageKey, Object ... placeholders) {
        String message = this.messagesConfig.getString(messageKey, "<red>Message not found: " + messageKey);
        Object component = placeholders.length > 0 ? this.miniMessage.deserialize(message, this.createTagResolvers(placeholders)) : this.miniMessage.deserialize(message);
        this.adventure.all().sendMessage((Component)component);
    }

    private TagResolver createTagResolvers(Object ... placeholders) {
        TagResolver[] resolvers = new TagResolver[placeholders.length / 2];
        for (int i = 0; i < placeholders.length; i += 2) {
            String key = placeholders[i].toString();
            String value = placeholders[i + 1].toString();
            resolvers[i / 2] = Placeholder.unparsed(key, value);
        }
        return TagResolver.resolver(resolvers);
    }

    private void sendWarningMessage(int seconds) {
        String specificKey = "warning.countdown-" + seconds;
        if (this.messagesConfig.contains(specificKey)) {
            this.broadcastMessage(specificKey, new Object[0]);
        } else {
            this.broadcastMessage("warning.countdown", "seconds", String.valueOf(seconds));
        }
    }

    private void startAutoClean() {
        if (this.autoCleanTask != null) {
            this.autoCleanTask.cancel();
        }
        this.autoCleanTask = new BukkitRunnable(){
            private int secondsLeft;
            {
                this.secondsLeft = LagCleaner.this.autoCleanInterval;
            }

            public void run() {
                if (LagCleaner.this.warningsEnabled && LagCleaner.this.warningTimes.contains(this.secondsLeft)) {
                    LagCleaner.this.sendWarningMessage(this.secondsLeft);
                }
                if (this.secondsLeft <= 0) {
                    LagCleaner.this.performCleanup((CommandSender)Bukkit.getConsoleSender(), false);
                    this.secondsLeft = LagCleaner.this.autoCleanInterval;
                }
                --this.secondsLeft;
            }
        };
        this.autoCleanTask.runTaskTimer((Plugin)this, 20L, 20L);
    }

    private void performCleanup(CommandSender sender, boolean showMessage) {
        int total;
        HashMap<String, Integer> removalCounts = new HashMap<String, Integer>();
        for (World world : Bukkit.getWorlds()) {
            if (this.clearDroppedItems) {
                int itemCount = 0;
                for (Entity entity : world.getEntities()) {
                    if (!(entity instanceof Item)) continue;
                    entity.remove();
                    ++itemCount;
                }
                if (itemCount > 0) {
                    removalCounts.put("Items", removalCounts.getOrDefault("Items", 0) + itemCount);
                }
            }
            if (this.clearMonsters) {
                int monsterCount = 0;
                for (Entity entity : world.getEntities()) {
                    if (!(entity instanceof Monster) || this.isExcludedMonster(entity)) continue;
                    entity.remove();
                    ++monsterCount;
                }
                if (monsterCount > 0) {
                    removalCounts.put("Monsters", removalCounts.getOrDefault("Monsters", 0) + monsterCount);
                }
            }
            if (!this.clearParticles) continue;
            removalCounts.put("Particles", removalCounts.getOrDefault("Particles", 0) + 1);
        }
        if (showMessage) {
            this.sendMessage(sender, "cleanup.header", new Object[0]);
            for (Map.Entry entry : removalCounts.entrySet()) {
                this.sendMessage(sender, "cleanup.item", "type", ((String)entry.getKey()).toLowerCase(), "count", String.valueOf(entry.getValue()));
            }
            if (removalCounts.isEmpty()) {
                this.sendMessage(sender, "cleanup.nothing", new Object[0]);
            }
        } else if (this.autoCleanEnabled && (total = removalCounts.values().stream().mapToInt(Integer::intValue).sum()) > 0) {
            this.broadcastMessage("cleanup.auto-complete", "total", String.valueOf(total));
        }
    }

    private boolean isExcludedMonster(Entity entity) {
        for (String excludedType : this.excludedMonsters) {
            try {
                EntityType type = EntityType.valueOf((String)excludedType.toUpperCase());
                if (entity.getType() != type) continue;
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return false;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("lagclear")) {
            if (!sender.hasPermission("lagcleaner.use")) {
                this.sendMessage(sender, "error.no-permission", new Object[0]);
                return true;
            }
            if (args.length == 0) {
                this.performCleanup(sender, true);
                return true;
            }
            if (args.length == 1) {
                if (args[0].equalsIgnoreCase("reload")) {
                    if (!sender.hasPermission("lagcleaner.reload")) {
                        this.sendMessage(sender, "error.no-permission-reload", new Object[0]);
                        return true;
                    }
                    this.reloadConfig();
                    this.loadConfig();
                    this.loadMessages();
                    if (this.autoCleanEnabled) {
                        this.startAutoClean();
                    } else if (this.autoCleanTask != null) {
                        this.autoCleanTask.cancel();
                        this.autoCleanTask = null;
                    }
                    this.sendMessage(sender, "config.reloaded", new Object[0]);
                    return true;
                }
                if (args[0].equalsIgnoreCase("toggle")) {
                    if (!sender.hasPermission("lagcleaner.toggle")) {
                        this.sendMessage(sender, "error.no-permission-toggle", new Object[0]);
                        return true;
                    }
                    this.autoCleanEnabled = !this.autoCleanEnabled;
                    this.config.set("auto-clean.enabled", (Object)this.autoCleanEnabled);
                    this.saveConfig();
                    if (this.autoCleanEnabled) {
                        this.startAutoClean();
                        this.sendMessage(sender, "auto-clean.enabled", new Object[0]);
                    } else {
                        if (this.autoCleanTask != null) {
                            this.autoCleanTask.cancel();
                            this.autoCleanTask = null;
                        }
                        this.sendMessage(sender, "auto-clean.disabled", new Object[0]);
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("now")) {
                    if (!sender.hasPermission("lagcleaner.now")) {
                        this.sendMessage(sender, "error.no-permission-now", new Object[0]);
                        return true;
                    }
                    this.sendMessage(sender, "cleanup.immediate-scheduled", new Object[0]);
                    this.scheduleImmediateCleanup();
                    return true;
                }
            }
            this.sendMessage(sender, "help.header", new Object[0]);
            this.sendMessage(sender, "help.clear", new Object[0]);
            this.sendMessage(sender, "help.reload", new Object[0]);
            this.sendMessage(sender, "help.toggle", new Object[0]);
            this.sendMessage(sender, "help.now", new Object[0]);
            return true;
        }
        return false;
    }

    private void scheduleImmediateCleanup() {
        final int maxWarningTime = this.warningTimes.isEmpty() ? 30 : this.warningTimes.stream().max(Integer::compare).orElse(30);
        new BukkitRunnable(this){
            private int secondsLeft;
            final /* synthetic */ LagCleaner this$0;
            {
                this.this$0 = this$0;
                this.secondsLeft = maxWarningTime;
            }

            public void run() {
                if (this.this$0.warningsEnabled && this.this$0.warningTimes.contains(this.secondsLeft)) {
                    this.this$0.sendWarningMessage(this.secondsLeft);
                }
                if (this.secondsLeft <= 0) {
                    this.this$0.performCleanup((CommandSender)Bukkit.getConsoleSender(), false);
                    this.this$0.broadcastMessage("cleanup.immediate-complete", new Object[0]);
                    this.cancel();
                }
                --this.secondsLeft;
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
    }
}

