/*
 * Decompiled with CFR 0.152.
 */
package net.Realism;

import dev.architectury.injectables.annotations.ExpectPlatform;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.Realism.fabric.RNetworkingImpl;
import net.Realism.network.ETCSStartStopPacket;
import net.Realism.network.ETCSSyncPacket;
import net.Realism.network.SteerDirectionPacket;
import net.Realism.util.C2SPacket;
import net.Realism.util.S2CPacket;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class RNetworking {
    private static final String VERSION = "4";
    private static int id = 0;
    private static final Map<Class<? extends C2SPacket>, Integer> c2sIdentifiers = new HashMap<Class<? extends C2SPacket>, Integer>();
    private static final Map<Class<? extends S2CPacket>, Integer> s2cIdentifiers = new HashMap<Class<? extends S2CPacket>, Integer>();
    private static final Map<Integer, Function<class_2540, ? extends C2SPacket>> c2sReaders = new HashMap<Integer, Function<class_2540, ? extends C2SPacket>>();
    private static final Map<Integer, Function<class_2540, ? extends S2CPacket>> s2cReaders = new HashMap<Integer, Function<class_2540, ? extends S2CPacket>>();

    private static <T extends S2CPacket> void registerS2C(Class<T> clazz, Function<class_2540, T> read) {
        int packetId = id++;
        s2cIdentifiers.put(clazz, packetId);
        s2cReaders.put(packetId, read);
    }

    private static <T extends C2SPacket> void registerC2S(Class<T> clazz, Function<class_2540, T> read) {
        int packetId = id++;
        c2sIdentifiers.put(clazz, packetId);
        c2sReaders.put(packetId, read);
    }

    public static <T extends C2SPacket> void sendInternal(T message, Consumer<class_2540> consumer) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10804(c2sIdentifiers.get(message.getClass()).intValue());
        message.write(buf);
        consumer.accept(buf);
    }

    public static <T extends S2CPacket> void sendInternal(T message, Consumer<class_2540> consumer) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10804(s2cIdentifiers.get(message.getClass()).intValue());
        message.write(buf);
        consumer.accept(buf);
    }

    public static void handleInternal(class_2540 buf, class_310 mc) {
        int packetId = buf.method_10816();
        S2CPacket packet = s2cReaders.get(packetId).apply(buf);
        mc.execute(() -> packet.handle(mc));
    }

    public static void handleInternal(class_2540 buf, class_3222 player) {
        int packetId = buf.method_10816();
        C2SPacket packet = c2sReaders.get(packetId).apply(buf);
        player.field_13995.execute(() -> packet.handle(player));
    }

    public static void onPlayerJoin(class_3222 player) {
        RNetworking.sendToPlayer(new CheckVersionS2CPacket(VERSION), player);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends S2CPacket> void sendToAll(T message) {
        RNetworkingImpl.sendToAll(message);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends S2CPacket> void sendToNear(T message, class_243 pos, int range, class_5321<class_1937> dimension) {
        void var3_3;
        void var2_2;
        void var1_1;
        RNetworkingImpl.sendToNear(message, (class_243)var1_1, (int)var2_2, (class_5321<class_1937>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends S2CPacket> void sendToPlayer(T message, class_3222 player) {
        void var1_1;
        RNetworkingImpl.sendToPlayer(message, (class_3222)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends C2SPacket> void sendToServer(T message) {
        RNetworkingImpl.sendToServer(message);
    }

    public static void register() {
        RNetworking.registerS2C(CheckVersionS2CPacket.class, CheckVersionS2CPacket::read);
        RNetworking.registerS2C(ETCSSyncPacket.class, ETCSSyncPacket::read);
        RNetworking.registerC2S(SteerDirectionPacket.class, SteerDirectionPacket::read);
        RNetworking.registerC2S(ETCSStartStopPacket.class, ETCSStartStopPacket::read);
    }

    private record CheckVersionS2CPacket(String serverVersion) implements S2CPacket
    {
        public static CheckVersionS2CPacket read(class_2540 buf) {
            return new CheckVersionS2CPacket(buf.method_19772());
        }

        @Override
        public void write(class_2540 buf) {
            buf.method_10814(this.serverVersion);
        }

        @Override
        public void handle(class_310 mc) {
            if (RNetworking.VERSION.equals(this.serverVersion)) {
                return;
            }
            mc.method_1562().method_10839((class_2561)class_2561.method_43470((String)"Create: Tramways network versions do not match! Server expected %s, client has %s".formatted(this.serverVersion, RNetworking.VERSION)));
        }
    }
}

