/*
 * Decompiled with CFR 0.152.
 */
package net.Realism.compat;

import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.TrackNode;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.Realism.Interfaces.ITramSignPoint;
import net.Realism.RealismExpectPlatform;
import net.Realism.RealismMod;
import net.Realism.mixinaccesors.TramSignDataAccessor;
import net.Realism.trains.SignalFinder;
import net.Realism.trains.etcs.ETCS;
import net.createmod.catnip.data.Couple;
import net.minecraft.class_2487;
import purplecreate.tramways.content.signs.TramSignPoint;
import purplecreate.tramways.content.signs.demands.SignDemand;
import purplecreate.tramways.content.signs.demands.TemporaryEndSignDemand;
import purplecreate.tramways.content.signs.demands.TemporarySpeedSignDemand;
import purplecreate.tramways.mixinInterfaces.ISpeedLimitableTrain;

public class TramwaysCompat {
    private static final boolean tramwaysLoaded = RealismExpectPlatform.isModLoaded("tramways");

    public static List<ETCS.SpeedLimit> processTramSigns(SignalFinder.SignalScanResult s, double Mspeed, Train train) {
        try {
            return TramwaysCompat.processTramSignsImpl(s, Mspeed, train);
        }
        catch (Throwable e) {
            RealismMod.LOGGER.error("Failed to process tram signs", e);
            return new ArrayList<ETCS.SpeedLimit>();
        }
    }

    public static List<ETCS.SpeedLimit> processTramSignsImpl(SignalFinder.SignalScanResult s, double maxSpeed, Train train) {
        ArrayList<ETCS.SpeedLimit> cachedSpeedLimits = new ArrayList<ETCS.SpeedLimit>();
        try {
            cachedSpeedLimits = new ArrayList();
            boolean first = true;
            int LastLimit = 300;
            for (SignalFinder.TramSignInfo sign : s.getTramSigns()) {
                if (sign == null || sign.getSign() == null) continue;
                Couple sides = null;
                if (sign.getSign() instanceof ITramSignPoint) {
                    sides = ((ITramSignPoint)sign.getSign()).getSides();
                } else {
                    try {
                        Field sidesField = TramSignPoint.class.getDeclaredField("sides");
                        sidesField.setAccessible(true);
                        sides = (Couple)sidesField.get(sign.getSign());
                    }
                    catch (Exception e) {
                        RealismMod.LOGGER.error("Error accessing sides field: " + e.getMessage());
                    }
                }
                if (sides == null) continue;
                class_2487 tag = null;
                SignDemand demand = null;
                if (sides.get(sign.getPrimary()) == null) continue;
                for (TramSignPoint.SignData signD : new HashSet((Collection)sides.get(sign.getPrimary()))) {
                    if (signD == null) continue;
                    if (!(signD instanceof TramSignDataAccessor)) {
                        try {
                            Field demandFieldExtra = TramSignPoint.SignData.class.getDeclaredField("demandExtra");
                            Field demandField = TramSignPoint.SignData.class.getDeclaredField("demand");
                            demandFieldExtra.setAccessible(true);
                            demandField.setAccessible(true);
                            tag = (class_2487)demandFieldExtra.get(signD);
                            demand = (SignDemand)demandField.get(signD);
                        }
                        catch (Exception e) {
                            RealismMod.LOGGER.error("Error accessing DemandExtra field: " + e.getMessage());
                        }
                    } else {
                        TramSignDataAccessor accessor = (TramSignDataAccessor)signD;
                        demand = accessor.getDemand();
                        if (demand == null) continue;
                        tag = accessor.getDemandExtra();
                    }
                    if (tag != null && tag.method_10545("Throttle")) {
                        double signSpeedLimit = tag.method_10550("Throttle");
                        signSpeedLimit = signSpeedLimit / 100.0 * maxSpeed;
                        cachedSpeedLimits.add(new ETCS.SpeedLimit(sign.getDistance(), signSpeedLimit));
                        if (demand instanceof TemporarySpeedSignDemand) {
                            LastLimit = (int)((ETCS.SpeedLimit)cachedSpeedLimits.get(cachedSpeedLimits.size() - 1)).speedLimit();
                        }
                        first = false;
                    }
                    if (demand instanceof TemporaryEndSignDemand && !first) {
                        cachedSpeedLimits.add(new ETCS.SpeedLimit(sign.getDistance(), LastLimit));
                    } else if (demand instanceof TemporarySpeedSignDemand && first) {
                        ISpeedLimitableTrain Ttrain = (ISpeedLimitableTrain)train;
                        double tempSpeedLimit = 300.0;
                        try {
                            Field tempSPeedLimitField = ISpeedLimitableTrain.class.getDeclaredField("tempSpeedLimit$actual");
                            tempSPeedLimitField.setAccessible(true);
                            tempSpeedLimit = (Double)tempSPeedLimitField.get(Ttrain);
                        }
                        catch (Exception e) {
                            RealismMod.LOGGER.error("Error accessing tempSpeedLimit field: " + e.getMessage());
                        }
                        cachedSpeedLimits.add(new ETCS.SpeedLimit(sign.getDistance(), tempSpeedLimit));
                    }
                    first = false;
                }
            }
        }
        catch (Exception e) {
            RealismMod.LOGGER.error("Error processing tram signs: " + e.getMessage(), (Throwable)e);
        }
        return cachedSpeedLimits;
    }

    public static boolean isLoaded() {
        return tramwaysLoaded;
    }

    public static Object createTramSignInfo(UUID signId, double distance, Object signType, boolean primary) {
        if (!tramwaysLoaded) {
            return null;
        }
        try {
            return TramwaysCompatImpl.createTramSignInfo(signId, distance, signType, primary);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isTramSignPoint(Object obj) {
        if (!tramwaysLoaded) {
            return false;
        }
        try {
            return TramwaysCompatImpl.isTramSignPoint(obj);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isPrimary(Object tramSign, Object node) {
        if (!tramwaysLoaded) {
            return false;
        }
        try {
            return TramwaysCompatImpl.isPrimary(tramSign, node);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static class TramwaysCompatImpl {
        private TramwaysCompatImpl() {
        }

        static Object createTramSignInfo(UUID signId, double distance, Object signType, boolean primary) {
            return new SignalFinder.TramSignInfo(signId, distance, signType, primary);
        }

        static boolean isTramSignPoint(Object obj) {
            return obj instanceof TramSignPoint;
        }

        static boolean isPrimary(Object tramSign, Object node) {
            return ((TramSignPoint)tramSign).isPrimary((TrackNode)node);
        }
    }
}

