/*
 * Decompiled with CFR 0.152.
 */
package net.Realism.trains.etcs;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class ETCStools {
    public static float calculateNeedleRotation(double trainSpeed) {
        float speedKmh = (float)Math.abs(trainSpeed * 20.0 * (double)3.6f);
        float rotationDegrees = speedKmh <= 160.0f ? -151.5f + 1.134f * speedKmh : 30.0f + 0.671f * (speedKmh - 160.0f);
        return rotationDegrees;
    }

    public static void renderElement(class_332 graphics, class_2960 path, int x, int y, int width, int height) {
        RenderSystem.setShaderTexture((int)0, (class_2960)path);
        graphics.method_25290(path, x, y, 0.0f, 0.0f, width, height, width, height);
    }

    public static void optimizedRenderSpeedCurve(class_332 graphics, class_4587 poseStack, int centerX, int centerY, double maxSpeed, int color) {
        int radius = 115;
        int arcWidth = 7;
        float startAngleRad = -4.0753436f;
        if (maxSpeed > 300.0) {
            maxSpeed = 300.0;
        }
        float endAngleRad = maxSpeed <= 160.0 ? (float)((-233.5 + (double)1.134f * maxSpeed) * 0.01745329238474369) : (float)((-50.0 + (double)0.671f * (maxSpeed - 160.0)) * 0.01745329238474369);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        int segments = 64;
        poseStack.method_22903();
        poseStack.method_46416((float)centerX, (float)centerY, 0.0f);
        Matrix4f matrix = poseStack.method_23760().method_23761();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
        for (int i = 0; i <= segments; ++i) {
            float ratio = (float)i / (float)segments;
            float angle = startAngleRad + (endAngleRad - startAngleRad) * ratio;
            float cos = (float)Math.cos(angle);
            float sin = (float)Math.sin(angle);
            float outerX = cos * (float)radius;
            float outerY = sin * (float)radius;
            buffer.method_22918(matrix, outerX, outerY, 0.0f).method_22915(r, g, b, a).method_1344();
            float innerX = cos * (float)(radius - arcWidth);
            float innerY = sin * (float)(radius - arcWidth);
            buffer.method_22918(matrix, innerX, innerY, 0.0f).method_22915(r, g, b, a).method_1344();
        }
        tesselator.method_1350();
        float endX = (float)Math.cos(endAngleRad) * ((float)radius - (float)arcWidth / 2.0f);
        float endY = (float)Math.sin(endAngleRad) * ((float)radius - (float)arcWidth / 2.0f);
        float innerEndX = (float)Math.cos(endAngleRad) * (float)(radius - arcWidth - 16);
        float innerEndY = (float)Math.sin(endAngleRad) * (float)(radius - arcWidth - 16);
        float perpX = -(endY - innerEndY);
        float perpY = endX - innerEndX;
        float perpLen = (float)Math.sqrt(perpX * perpX + perpY * perpY);
        perpX = perpX / perpLen * 2.0f;
        perpY = perpY / perpLen * 2.0f;
        buffer.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
        buffer.method_22918(matrix, endX + perpX, endY + perpY, 0.0f).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, endX - perpX, endY - perpY, 0.0f).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, innerEndX + perpX, innerEndY + perpY, 0.0f).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, innerEndX - perpX, innerEndY - perpY, 0.0f).method_22915(r, g, b, a).method_1344();
        tesselator.method_1350();
        RenderSystem.disableBlend();
        poseStack.method_22909();
    }
}

