/*
 * Decompiled with CFR 0.152.
 */
package net.Realism;

import dev.architectury.injectables.annotations.ExpectPlatform;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.Realism.forge.RNetworkingImpl;
import net.Realism.network.ETCSStartStopPacket;
import net.Realism.network.ETCSSyncPacket;
import net.Realism.network.SteerDirectionPacket;
import net.Realism.util.C2SPacket;
import net.Realism.util.S2CPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class RNetworking {
    private static final String VERSION = "4";
    private static int id = 0;
    private static final Map<Class<? extends C2SPacket>, Integer> c2sIdentifiers = new HashMap<Class<? extends C2SPacket>, Integer>();
    private static final Map<Class<? extends S2CPacket>, Integer> s2cIdentifiers = new HashMap<Class<? extends S2CPacket>, Integer>();
    private static final Map<Integer, Function<FriendlyByteBuf, ? extends C2SPacket>> c2sReaders = new HashMap<Integer, Function<FriendlyByteBuf, ? extends C2SPacket>>();
    private static final Map<Integer, Function<FriendlyByteBuf, ? extends S2CPacket>> s2cReaders = new HashMap<Integer, Function<FriendlyByteBuf, ? extends S2CPacket>>();

    private static <T extends S2CPacket> void registerS2C(Class<T> clazz, Function<FriendlyByteBuf, T> read) {
        int packetId = id++;
        s2cIdentifiers.put(clazz, packetId);
        s2cReaders.put(packetId, read);
    }

    private static <T extends C2SPacket> void registerC2S(Class<T> clazz, Function<FriendlyByteBuf, T> read) {
        int packetId = id++;
        c2sIdentifiers.put(clazz, packetId);
        c2sReaders.put(packetId, read);
    }

    public static <T extends C2SPacket> void sendInternal(T message, Consumer<FriendlyByteBuf> consumer) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130130_(c2sIdentifiers.get(message.getClass()).intValue());
        message.write(buf);
        consumer.accept(buf);
    }

    public static <T extends S2CPacket> void sendInternal(T message, Consumer<FriendlyByteBuf> consumer) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130130_(s2cIdentifiers.get(message.getClass()).intValue());
        message.write(buf);
        consumer.accept(buf);
    }

    public static void handleInternal(FriendlyByteBuf buf, Minecraft mc) {
        int packetId = buf.m_130242_();
        S2CPacket packet = s2cReaders.get(packetId).apply(buf);
        mc.execute(() -> packet.handle(mc));
    }

    public static void handleInternal(FriendlyByteBuf buf, ServerPlayer player) {
        int packetId = buf.m_130242_();
        C2SPacket packet = c2sReaders.get(packetId).apply(buf);
        player.f_8924_.execute(() -> packet.handle(player));
    }

    public static void onPlayerJoin(ServerPlayer player) {
        RNetworking.sendToPlayer(new CheckVersionS2CPacket(VERSION), player);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends S2CPacket> void sendToAll(T message) {
        RNetworkingImpl.sendToAll(message);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends S2CPacket> void sendToNear(T message, Vec3 pos, int range, ResourceKey<Level> dimension) {
        void var3_3;
        void var2_2;
        void var1_1;
        RNetworkingImpl.sendToNear(message, (Vec3)var1_1, (int)var2_2, (ResourceKey<Level>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends S2CPacket> void sendToPlayer(T message, ServerPlayer player) {
        void var1_1;
        RNetworkingImpl.sendToPlayer(message, (ServerPlayer)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends C2SPacket> void sendToServer(T message) {
        RNetworkingImpl.sendToServer(message);
    }

    public static void register() {
        RNetworking.registerS2C(CheckVersionS2CPacket.class, CheckVersionS2CPacket::read);
        RNetworking.registerS2C(ETCSSyncPacket.class, ETCSSyncPacket::read);
        RNetworking.registerC2S(SteerDirectionPacket.class, SteerDirectionPacket::read);
        RNetworking.registerC2S(ETCSStartStopPacket.class, ETCSStartStopPacket::read);
    }

    private record CheckVersionS2CPacket(String serverVersion) implements S2CPacket
    {
        public static CheckVersionS2CPacket read(FriendlyByteBuf buf) {
            return new CheckVersionS2CPacket(buf.m_130277_());
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_130070_(this.serverVersion);
        }

        @Override
        public void handle(Minecraft mc) {
            if (RNetworking.VERSION.equals(this.serverVersion)) {
                return;
            }
            mc.m_91403_().m_7026_((Component)Component.m_237113_((String)"Create: Tramways network versions do not match! Server expected %s, client has %s".formatted(this.serverVersion, RNetworking.VERSION)));
        }
    }
}

