/*
 * Decompiled with CFR 0.152.
 */
package net.Realism.debug;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.Realism.config.RealismConfig;
import net.minecraft.client.Minecraft;

public class RealismDebuger {
    private static final RealismDebuger INSTANCE = new RealismDebuger();
    private final Queue<String> pendingMessages = new LinkedList<String>();
    private final Set<String> knownMessages = new HashSet<String>();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private boolean isRunning = false;
    private boolean hasNewData = false;

    private RealismDebuger() {
        this.startLogging();
    }

    public static RealismDebuger getInstance() {
        return INSTANCE;
    }

    public void startLogging() {
        if (!this.isRunning) {
            this.isRunning = true;
            this.scheduler.scheduleAtFixedRate(this::logDebugInfo, 0L, 5L, TimeUnit.SECONDS);
        }
    }

    public void stopLogging() {
        if (this.isRunning) {
            this.scheduler.shutdown();
            this.isRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDebugInfo(float acceleration, int carriageCount, int locomotiveCount) {
        if (((Boolean)RealismConfig.CLIENT.debugMode.get()).booleanValue()) {
            String message = String.format("Train acceleration: %.5f | Carriages: %d | PowerCars: %d", Float.valueOf(acceleration), carriageCount, locomotiveCount);
            Queue<String> queue = this.pendingMessages;
            synchronized (queue) {
                if (!this.knownMessages.contains(message)) {
                    this.pendingMessages.offer(message);
                    this.knownMessages.add(message);
                    this.hasNewData = true;
                    if (this.knownMessages.size() > 100) {
                        this.knownMessages.clear();
                        this.knownMessages.addAll(this.pendingMessages);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logDebugInfo() {
        if (!((Boolean)RealismConfig.CLIENT.debugMode.get()).booleanValue() || Minecraft.m_91087_().f_91073_ == null || !this.hasNewData) {
            return;
        }
        Queue<String> queue = this.pendingMessages;
        synchronized (queue) {
            if (!this.pendingMessages.isEmpty()) {
                System.out.println("=== REALISM DEBUG INFO ===");
                for (String message : this.pendingMessages) {
                    System.out.println(message);
                }
                this.pendingMessages.clear();
                System.out.println("======================");
                this.hasNewData = false;
            }
        }
    }
}

