/*
 * Decompiled with CFR 0.152.
 */
package net.Realism.forge;

import java.util.function.Supplier;
import net.Realism.RNetworking;
import net.Realism.RealismMod;
import net.Realism.util.C2SPacket;
import net.Realism.util.S2CPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class RNetworkingImpl {
    private static final SimpleChannel net = NetworkRegistry.ChannelBuilder.named((ResourceLocation)RealismMod.id("net")).networkProtocolVersion(() -> "null").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();

    public static void init() {
        net.messageBuilder(ForgePacket.class, 0).encoder(ForgePacket::write).decoder(ForgePacket::read).consumerMainThread(ForgePacket::handle).add();
    }

    public static <T extends S2CPacket> void sendToAll(T message) {
        RNetworking.sendInternal(message, buf -> net.send(PacketDistributor.ALL.noArg(), (Object)new ForgePacket((FriendlyByteBuf)buf)));
    }

    public static <T extends S2CPacket> void sendToNear(T message, Vec3 pos, int range, ResourceKey<Level> dimension) {
        RNetworking.sendInternal(message, buf -> net.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_, (double)range, (ResourceKey)dimension)), (Object)new ForgePacket((FriendlyByteBuf)buf)));
    }

    public static <T extends S2CPacket> void sendToPlayer(T message, ServerPlayer player) {
        RNetworking.sendInternal(message, buf -> net.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ForgePacket((FriendlyByteBuf)buf)));
    }

    public static <T extends C2SPacket> void sendToServer(T message) {
        RNetworking.sendInternal(message, buf -> net.sendToServer((Object)new ForgePacket((FriendlyByteBuf)buf)));
    }

    private record ForgePacket(FriendlyByteBuf message) {
        public static ForgePacket read(FriendlyByteBuf buf) {
            int length = buf.m_130242_();
            FriendlyByteBuf message = new FriendlyByteBuf(buf.readBytes(length));
            return new ForgePacket(message);
        }

        public void write(FriendlyByteBuf buf) {
            byte[] array = this.message.array();
            buf.m_130130_(array.length);
            buf.writeBytes(array);
        }

        public void handle(Supplier<NetworkEvent.Context> context) {
            switch (context.get().getDirection()) {
                case PLAY_TO_CLIENT: {
                    RNetworking.handleInternal(this.message, Minecraft.m_91087_());
                    break;
                }
                case PLAY_TO_SERVER: {
                    RNetworking.handleInternal(this.message, context.get().getSender());
                }
            }
        }
    }
}

