/*
 * Decompiled with CFR 0.152.
 */
package net.Realism.mixin;

import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TrainStatus;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.Realism.Interfaces.ITrainInterface;
import net.Realism.config.RealismConfig;
import net.Realism.debug.RealismDebuger;
import net.Realism.trains.etcs.ETCS;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Train.class}, remap=false)
public abstract class TrainMixin
implements ITrainInterface {
    @Shadow
    public int fuelTicks;
    @Shadow
    public List<Carriage> carriages;
    @Shadow
    public ScheduleRuntime runtime;
    @Shadow
    public TrainStatus status;
    @Shadow
    public boolean manualTick;
    @Unique
    public ETCS realism$etcs = null;

    @Override
    @Unique
    public void realism$setETCS(ETCS etcs) {
        this.realism$etcs = etcs;
    }

    @Override
    @Unique
    public ETCS realism$getETCS() {
        return this.realism$etcs;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        if (this.realism$etcs == null) {
            this.realism$setETCS(new ETCS((Train)this));
        }
        if (this.realism$etcs.toUpdate) {
            this.realism$etcs.update();
        }
    }

    @Inject(method={"write"}, at={@At(value="RETURN")}, cancellable=true)
    private void write(DimensionPalette dimensions, CallbackInfoReturnable<CompoundTag> cir) {
        if (this.realism$etcs != null) {
            CompoundTag tag = (CompoundTag)cir.getReturnValue();
            tag.m_128365_("ETCS", (Tag)this.realism$etcs.saveToNBT());
            cir.setReturnValue((Object)tag);
        }
    }

    @Inject(method={"read"}, at={@At(value="RETURN")}, cancellable=true)
    private static void onTrainRead(CompoundTag tag, Map<UUID, TrackGraph> trackNetworks, DimensionPalette dimensions, CallbackInfoReturnable<Train> cir) {
        Train original = (Train)cir.getReturnValue();
        if (tag.m_128441_("ETCS")) {
            CompoundTag customDataTag = tag.m_128469_("ETCS");
            ((ITrainInterface)original).realism$setETCS(new ETCS(original));
            ((ITrainInterface)original).realism$getETCS().loadFromNBT(customDataTag);
        }
    }

    @Overwrite
    public float acceleration() {
        float reduce;
        if (!((Boolean)RealismConfig.COMMON.EnableCustomTrainAcceleration.get()).booleanValue()) {
            return (this.fuelTicks > 0 ? AllConfigs.server().trains.poweredTrainAcceleration.getF() : AllConfigs.server().trains.trainAcceleration.getF()) / 400.0f;
        }
        float ac = (this.fuelTicks > 0 ? AllConfigs.server().trains.poweredTrainAcceleration.getF() : AllConfigs.server().trains.trainAcceleration.getF()) / 400.0f;
        int locomotives = 0;
        for (Carriage carriage : this.carriages) {
            if (!carriage.presentConductors.either(b -> b)) continue;
            ++locomotives;
        }
        if (locomotives == 0) {
            locomotives = 1;
        }
        if ((ac -= (reduce = (float)((double)((float)this.carriages.size() * 2.0E-4f) * (Double)RealismConfig.COMMON.CustomTrainAccelerationMultiplyer.get() / (double)locomotives))) < 0.0f) {
            ac = 1.0E-4f;
        }
        if (((Boolean)RealismConfig.CLIENT.debugMode.get()).booleanValue()) {
            RealismDebuger.getInstance().addDebugInfo(ac * 400.0f, this.carriages.size(), locomotives);
        }
        return ac;
    }
}

