/*
 * Decompiled with CFR 0.152.
 */
package net.Realism.network;

import com.simibubi.create.CreateClient;
import com.simibubi.create.content.trains.entity.Train;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.Realism.Interfaces.ITrainInterface;
import net.Realism.RealismMod;
import net.Realism.trains.etcs.ETCS;
import net.Realism.util.S2CPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;

public class ETCSSyncPacket
implements S2CPacket {
    private final UUID trainId;
    private final double distanceToSignal;
    private final double speedLimit;
    private final float needleRotation;
    private final boolean backward;
    private final double emergencyBrakingDist;
    private final double serviceBrakingDist;
    private final double warningBrakingDist;
    private final boolean cachedCurveIsDropping;
    private final List<ETCS.SpeedLimit> speedLimits;
    private final int zoom;
    private final boolean newRoute;
    private final double distanceToBrakingPoint;
    private final boolean toUpdate;

    public ETCSSyncPacket(UUID trainId, double distanceToSignal, double speedLimit, float needleRotation, boolean backward, double emergencyBrakingDist, double serviceBrakingDist, double warningBrakingDist, boolean cachedCurveIsDropping, List<ETCS.SpeedLimit> speedLimits, int zoom, boolean newRoute, double distanceToBrakingPoint, boolean toUpdate) {
        this.trainId = trainId;
        this.distanceToSignal = distanceToSignal;
        this.speedLimit = speedLimit;
        this.needleRotation = needleRotation;
        this.backward = backward;
        this.emergencyBrakingDist = emergencyBrakingDist;
        this.serviceBrakingDist = serviceBrakingDist;
        this.warningBrakingDist = warningBrakingDist;
        this.cachedCurveIsDropping = cachedCurveIsDropping;
        this.speedLimits = speedLimits;
        this.zoom = zoom;
        this.newRoute = newRoute;
        this.distanceToBrakingPoint = distanceToBrakingPoint;
        this.toUpdate = toUpdate;
    }

    public static ETCSSyncPacket read(FriendlyByteBuf buffer) {
        UUID trainId = buffer.m_130259_();
        double distanceToSignal = buffer.readDouble();
        double speedLimit = buffer.readDouble();
        float needleRotation = buffer.readFloat();
        boolean backward = buffer.readBoolean();
        double emergencyBrakingDist = buffer.readDouble();
        double serviceBrakingDist = buffer.readDouble();
        double warningBrakingDist = buffer.readDouble();
        boolean cachedCurveIsDropping = buffer.readBoolean();
        int zoom = buffer.readInt();
        boolean newRoute = buffer.readBoolean();
        double distanceToBrakingPoint = buffer.readDouble();
        int speedLimitCount = buffer.readInt();
        boolean toUpdate = buffer.readBoolean();
        ArrayList<ETCS.SpeedLimit> speedLimits = new ArrayList<ETCS.SpeedLimit>();
        for (int i = 0; i < speedLimitCount; ++i) {
            double distance = buffer.readDouble();
            double limit = buffer.readDouble();
            speedLimits.add(new ETCS.SpeedLimit(distance, limit));
        }
        return new ETCSSyncPacket(trainId, distanceToSignal, speedLimit, needleRotation, backward, emergencyBrakingDist, serviceBrakingDist, warningBrakingDist, cachedCurveIsDropping, speedLimits, zoom, newRoute, distanceToBrakingPoint, toUpdate);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.trainId);
        buffer.writeDouble(this.distanceToSignal);
        buffer.writeDouble(this.speedLimit);
        buffer.writeFloat(this.needleRotation);
        buffer.writeBoolean(this.backward);
        buffer.writeDouble(this.emergencyBrakingDist);
        buffer.writeDouble(this.serviceBrakingDist);
        buffer.writeDouble(this.warningBrakingDist);
        buffer.writeBoolean(this.cachedCurveIsDropping);
        buffer.writeInt(this.zoom);
        buffer.writeBoolean(this.newRoute);
        buffer.writeDouble(this.distanceToBrakingPoint);
        buffer.writeInt(this.speedLimits.size());
        buffer.writeBoolean(this.toUpdate);
        for (ETCS.SpeedLimit limit : this.speedLimits) {
            buffer.writeDouble(limit.distance());
            buffer.writeDouble(limit.speedLimit());
        }
    }

    @Override
    public void handle(Minecraft mc) {
        mc.execute(() -> {
            try {
                Object patt0$temp;
                if (CreateClient.RAILWAYS.trains.get(this.trainId) != null && (patt0$temp = CreateClient.RAILWAYS.trains.get(this.trainId)) instanceof ITrainInterface) {
                    ITrainInterface trainInterface = (ITrainInterface)patt0$temp;
                    if (trainInterface.realism$getETCS() == null) {
                        trainInterface.realism$setETCS(new ETCS((Train)CreateClient.RAILWAYS.trains.get(this.trainId)));
                    }
                    trainInterface.realism$getETCS().updateFromNetwork(this.distanceToSignal, this.speedLimit, this.needleRotation, this.backward, this.emergencyBrakingDist, this.serviceBrakingDist, this.warningBrakingDist, this.cachedCurveIsDropping, this.speedLimits, this.zoom, this.newRoute, this.distanceToBrakingPoint, this.toUpdate);
                }
            }
            catch (Exception e) {
                RealismMod.LOGGER.error("Error handling ETCS sync packet", (Throwable)e);
            }
        });
    }
}

