/*
 * Decompiled with CFR 0.152.
 */
package net.Realism.network;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.Realism.util.C2SPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class SteerDirectionPacket
implements C2SPacket {
    private static final Map<UUID, KeyPressType> playerKeyPresses = new HashMap<UUID, KeyPressType>();
    private final KeyPressType keyPress;

    public SteerDirectionPacket(KeyPressType keyPress) {
        this.keyPress = keyPress;
    }

    public SteerDirectionPacket(FriendlyByteBuf buf) {
        this.keyPress = (KeyPressType)buf.m_130066_(KeyPressType.class);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.keyPress);
    }

    @Override
    public void handle(ServerPlayer player) {
        playerKeyPresses.put(player.m_20148_(), this.keyPress);
    }

    public static SteerDirectionPacket read(FriendlyByteBuf buffer) {
        KeyPressType keys = (KeyPressType)buffer.m_130066_(KeyPressType.class);
        return new SteerDirectionPacket(keys);
    }

    public static KeyPressType getPlayerKeyPress(UUID playerId) {
        return playerKeyPresses.getOrDefault(playerId, KeyPressType.NONE);
    }

    public static void setPlayerKeyPresses(UUID playerId, KeyPressType keyPress) {
        playerKeyPresses.put(playerId, keyPress);
    }

    public static enum KeyPressType {
        PLUS,
        MINUS,
        NONE;

    }
}

