/*
 * Decompiled with CFR 0.152.
 */
package net.Realism.trains;

import com.simibubi.create.Create;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.signal.SignalBlock;
import com.simibubi.create.content.trains.signal.SignalBoundary;
import com.simibubi.create.content.trains.signal.SignalEdgeGroup;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.Realism.compat.TramwaysCompat;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Pair;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;

public class SignalFinder {
    public static SignalScanResult scanAheadForSignals(Train train, double maxDistance) {
        boolean isMovingBackward = train.speed < 0.0;
        return SignalFinder.scanAheadForSignals(train, maxDistance, isMovingBackward);
    }

    public static SignalScanResult scanAheadForSignals(Train train, double maxDistance, boolean isMovingBackward) {
        SignalScanResult result = new SignalScanResult();
        if (train.graph == null) {
            return result;
        }
        TravellingPoint scout = new TravellingPoint();
        if (isMovingBackward) {
            TravellingPoint startPoint = ((Carriage)train.carriages.get(train.carriages.size() - 1)).getTrailingPoint();
            scout.node1 = startPoint.node1;
            scout.node2 = startPoint.node2;
            scout.edge = startPoint.edge;
            scout.position = startPoint.position;
            maxDistance = -maxDistance;
        } else {
            TravellingPoint startPoint = ((Carriage)train.carriages.get(0)).getLeadingPoint();
            scout.node1 = startPoint.node1;
            scout.node2 = startPoint.node2;
            scout.edge = startPoint.edge;
            scout.position = startPoint.position;
        }
        MutableDouble crossSignalDistanceTracker = new MutableDouble(-1.0);
        MutableObject trackingCrossSignal = new MutableObject(null);
        HashMap chainedGroups = new HashMap();
        TravellingPoint.SteerDirection steerDirection = TravellingPoint.SteerDirection.NONE;
        if (train.manualSteer != null) {
            steerDirection = train.manualSteer;
        }
        double distanceTraveled = scout.travel(train.graph, maxDistance, scout.steer(steerDirection, new Vec3(0.0, 1.0, 0.0)), (distance, couple) -> {
            boolean crossSignalTracked;
            Couple nodes = (Couple)couple.getSecond();
            TrackEdgePoint bond = (TrackEdgePoint)couple.getFirst();
            if (TramwaysCompat.isTramSignPoint(bond)) {
                boolean primary = TramwaysCompat.isPrimary(bond, nodes.getSecond());
                result.addTramSign(bond, (double)distance, primary);
                return false;
            }
            if (!(bond instanceof SignalBoundary)) {
                return false;
            }
            SignalBoundary signal = (SignalBoundary)bond;
            if (train.speed > 0.2 && distance < 5.0) {
                return false;
            }
            UUID entering = signal.getGroup((TrackNode)nodes.getSecond());
            SignalEdgeGroup signalEdgeGroup = (SignalEdgeGroup)Create.RAILWAYS.signalEdgeGroups.get(entering);
            if (signalEdgeGroup == null) {
                return false;
            }
            boolean primary = entering.equals(signal.groups.getFirst());
            boolean crossSignal = signal.types.get(primary) == SignalBlock.SignalType.CROSS_SIGNAL;
            boolean occupied = signal.isForcedRed((TrackNode)nodes.getSecond()) || signalEdgeGroup.isOccupiedUnless(train);
            boolean bl = crossSignalTracked = trackingCrossSignal.getValue() != null;
            if (!crossSignalTracked) {
                if (crossSignal) {
                    trackingCrossSignal.setValue((Object)Pair.of((Object)signal, (Object)primary));
                    crossSignalDistanceTracker.setValue((Number)distance);
                    chainedGroups.put(entering, Pair.of((Object)signal, (Object)primary));
                }
                if (occupied) {
                    result.addSignal(signal, (double)distance, primary, occupied, crossSignal, entering);
                    return !crossSignal;
                }
            } else if (crossSignalTracked) {
                chainedGroups.put(entering, Pair.of((Object)signal, (Object)primary));
                if (occupied) {
                    Pair crossSignalPair = (Pair)trackingCrossSignal.getValue();
                    result.addSignal((SignalBoundary)crossSignalPair.getFirst(), crossSignalDistanceTracker.doubleValue(), (Boolean)crossSignalPair.getSecond(), occupied, true, entering);
                    if (!crossSignal) {
                        return true;
                    }
                }
                if (!crossSignal) {
                    trackingCrossSignal.setValue(null);
                }
            }
            return false;
        }, (distance, edge) -> {});
        double actualMaxDistance = Math.abs(maxDistance);
        if (Math.abs(distanceTraveled) < actualMaxDistance - 0.1) {
            result.endOfTrack(Math.abs(distanceTraveled));
        }
        return result;
    }

    public static class SignalScanResult {
        private final List<SignalInfo> signals = new ArrayList<SignalInfo>();
        private final List<TramSignInfo> tramSigns = new ArrayList<TramSignInfo>();

        public void addSignal(SignalBoundary signal, double distance, boolean primary, boolean occupied, boolean isCrossSignal, UUID groupId) {
            this.signals.add(new SignalInfo(signal.id, groupId, distance, primary, occupied, isCrossSignal));
        }

        public void addTramSign(Object tramSign, double distance, boolean primary) {
            if (!TramwaysCompat.isLoaded()) {
                return;
            }
            Object tramSignInfo = TramwaysCompat.createTramSignInfo((UUID)this.getFieldValue(tramSign, "id"), distance, tramSign, primary);
            if (tramSignInfo != null) {
                this.tramSigns.add((TramSignInfo)tramSignInfo);
            }
        }

        private Object getFieldValue(Object obj, String fieldName) {
            try {
                Field field = obj.getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                return field.get(obj);
            }
            catch (Exception e) {
                return null;
            }
        }

        public List<SignalInfo> getSignals() {
            return this.signals;
        }

        public List<TramSignInfo> getTramSigns() {
            return this.tramSigns;
        }

        public TramSignInfo getClosestTramSign() {
            return this.tramSigns.stream().min(Comparator.comparing(TramSignInfo::getDistance)).orElse(null);
        }

        public SignalInfo getClosestOccupiedSignal() {
            return this.signals.stream().filter(SignalInfo::occupied).min(Comparator.comparing(SignalInfo::distance)).orElse(null);
        }

        public boolean hasBlockedPath() {
            return this.getClosestOccupiedSignal() != null;
        }

        public double getDistanceToClosestOccupiedSignal() {
            SignalInfo signal = this.getClosestOccupiedSignal();
            return signal != null ? signal.distance() : Double.MAX_VALUE;
        }

        public void endOfTrack(double distance) {
            this.signals.add(new SignalInfo(null, null, distance, true, true, false));
        }
    }

    public static class TramSignInfo {
        private final UUID signId;
        private final double distance;
        private final Object signType;
        private final boolean primary;

        public TramSignInfo(UUID signId, double distance, Object signType, boolean primary) {
            this.signId = signId;
            this.distance = distance;
            this.signType = signType;
            this.primary = primary;
        }

        public Object getSign() {
            return this.signType;
        }

        public UUID getSignId() {
            return this.signId;
        }

        public double getDistance() {
            return this.distance;
        }

        public boolean getPrimary() {
            return this.primary;
        }
    }

    public record SignalInfo(UUID signalId, UUID groupId, double distance, boolean primary, boolean occupied, boolean isCrossSignal) {
    }
}

