/*
 * Decompiled with CFR 0.152.
 */
package net.Realism.trains.etcs;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Train;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.Realism.RNetworking;
import net.Realism.RealismExpectPlatform;
import net.Realism.compat.TramwaysCompat;
import net.Realism.config.RealismConfig;
import net.Realism.network.ETCSStartStopPacket;
import net.Realism.network.ETCSSyncPacket;
import net.Realism.network.SteerDirectionPacket;
import net.Realism.trains.SignalFinder;
import net.Realism.trains.etcs.ETCSsounds;
import net.Realism.trains.etcs.ETCStools;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;

public class ETCS {
    boolean backward = false;
    public Train train;
    public SignalFinder.SignalScanResult previousSignalScanResult;
    boolean previousBackward;
    private double speedLimit = -1.0;
    private double distanceToSignal = 0.0;
    private float needleRotationDegrees = 0.0f;
    private long lastUpdateTime = 0L;
    private boolean needsSync = false;
    private long lastSyncTime = 0L;
    private static final int SYNC_INTERVAL_MS = 200;
    private int curvedropping;
    private int diffrenceCounter = 0;
    private int zoom = 1;
    private boolean pendingBeepSound = false;
    private double cachedEmergencyBrakingDist;
    private double cachedServiceBrakingDist;
    private double cachedWarningBrakingDist;
    private boolean cachedCurveIsDropping = false;
    private double cachedAllowedSpeed = -1.0;
    private List<SpeedLimit> cachedSpeedLimits = new ArrayList<SpeedLimit>();
    private double distanceToBrakingPoint = 0.0;
    private boolean plusKeyWasDown = false;
    private boolean minusKeyWasDown = false;
    private long lastKeyPressTime = 0L;
    private static final long KEY_COOLDOWN_MS = 300L;
    private int trackspeedlimit = 300;
    public boolean toUpdate = false;

    public ETCS(Train train) {
        this.train = train;
    }

    public void update() {
        this.lastUpdateTime = System.currentTimeMillis();
        if (this.train.speed < 0.0) {
            this.previousBackward = this.backward;
            this.backward = true;
        } else if (this.train.speed > 0.0) {
            this.previousBackward = this.backward;
            this.backward = false;
        }
        this.ReciveKeys();
        SignalFinder.SignalScanResult s = SignalFinder.scanAheadForSignals(this.train, 4000.0 / (double)this.zoom, this.backward);
        if (this.previousSignalScanResult != null) {
            if (this.diffrenceCounter < 10) {
                if (Math.abs(s.getDistanceToClosestOccupiedSignal() - this.previousSignalScanResult.getDistanceToClosestOccupiedSignal()) > 30.0 && this.backward == this.previousBackward) {
                    ++this.diffrenceCounter;
                    s = this.previousSignalScanResult;
                }
            } else {
                this.pendingBeepSound = true;
                this.diffrenceCounter = 0;
            }
        }
        this.previousSignalScanResult = s;
        this.distanceToSignal = s.getDistanceToClosestOccupiedSignal();
        if (RealismExpectPlatform.isModLoaded("tramways")) {
            if (this.trackspeedlimit == 0) {
                this.trackspeedlimit = 20;
            }
            this.cachedSpeedLimits = TramwaysCompat.processTramSigns(s, this.train.maxSpeed() * 20.0f * 3.6f, this.train);
        } else {
            this.cachedSpeedLimits = new ArrayList<SpeedLimit>();
            this.trackspeedlimit = 300;
        }
        float distance = (float)s.getDistanceToClosestOccupiedSignal();
        float maxDeceleration = this.train.acceleration() * 2.0f * 400.0f;
        this.updateBrakingDistances(this.trackspeedlimit, 0);
        this.speedLimit = Math.min(this.calculateAllowedSpeed(distance, maxDeceleration), this.trackspeedlimit);
        this.updateBrakingDistances((int)(this.train.speed * 20.0 * (double)3.6f), 0);
        if (this.cachedAllowedSpeed > this.speedLimit) {
            this.cachedCurveIsDropping = true;
            this.curvedropping = 0;
        } else {
            ++this.curvedropping;
            if (this.curvedropping > 10) {
                this.cachedCurveIsDropping = false;
            }
        }
        this.cachedAllowedSpeed = this.speedLimit;
        this.needleRotationDegrees = ETCStools.calculateNeedleRotation(this.train.speed);
        this.markDirty();
        this.syncToClients();
    }

    public void start() {
        this.toUpdate = true;
        RNetworking.sendToServer(new ETCSStartStopPacket(this.toUpdate, this.train.id));
    }

    public void stop() {
        this.toUpdate = false;
        RNetworking.sendToServer(new ETCSStartStopPacket(this.toUpdate, this.train.id));
    }

    public void render(GuiGraphics graphics) {
        PoseStack posestack = graphics.m_280168_();
        double ScaleFactor = (Double)RealismConfig.CLIENT.ETCSSize.get();
        posestack.m_85836_();
        posestack.m_85841_((float)ScaleFactor, (float)ScaleFactor, (float)ScaleFactor);
        this.sendKeysToServer();
        int screenWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        int xPos = (int)((double)screenWidth / ScaleFactor - 536.0);
        int yPos = 0;
        if (this.zoom == 0) {
            this.zoom = 1;
        }
        String zoomTexture = String.format("realism:textures/etcszoom%d.png", this.zoom);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation(zoomTexture));
        graphics.m_280163_(new ResourceLocation(zoomTexture), xPos, yPos, 0.0f, 0.0f, 536, 401, 536, 401);
        posestack.m_85836_();
        posestack.m_252880_((float)(xPos + 167), (float)(yPos + 130), 0.0f);
        float rotationRadians = this.needleRotationDegrees * ((float)Math.PI / 180);
        posestack.m_252781_(Axis.f_252403_.m_252961_(rotationRadians));
        posestack.m_252880_(-24.0f, -89.0f, 0.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("realism:textures/etcshand.png"));
        graphics.m_280163_(new ResourceLocation("realism:textures/etcshand.png"), 0, 0, 0.0f, 0.0f, 49, 112, 49, 112);
        posestack.m_85849_();
        if (this.pendingBeepSound) {
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel level = mc.f_91073_;
            if (level != null) {
                ETCSsounds.playBeepSound();
            }
            this.pendingBeepSound = false;
        }
        this.renderETCSlimits(graphics, posestack, xPos + 10, yPos + 10);
        this.renderOverviewItems(graphics, xPos, yPos, this.zoom);
        this.renderBrakingCurve(graphics, posestack, xPos + 10, yPos + 10);
        ETCSsounds.updateWarningLoop();
        posestack.m_85849_();
    }

    public void renderETCSlimits(GuiGraphics graphics, PoseStack posestack, int Xpos, int Ypos) {
        posestack.m_85836_();
        posestack.m_252880_((float)(Xpos + 361), (float)(Ypos + 227), 0.0f);
        int CurrentY = 0;
        ResourceLocation startTex = new ResourceLocation("realism:textures/etcsplusstart.png");
        ResourceLocation midTex = new ResourceLocation("realism:textures/etcsplusmid.png");
        ResourceLocation endTex = new ResourceLocation("realism:textures/etcsplusend.png");
        ResourceLocation flagTex = new ResourceLocation("realism:textures/flag.png");
        double scaledMax = 4000.0 / (double)this.zoom;
        double scaledBoundary1 = 1.0 / (double)this.zoom;
        double scaledBoundary2 = 100.0 / (double)this.zoom;
        double scaledBoundary3 = 200.0 / (double)this.zoom;
        double scaledBoundary4 = 300.0 / (double)this.zoom;
        double scaledBoundary5 = 400.0 / (double)this.zoom;
        double scaledBoundary6 = 500.0 / (double)this.zoom;
        double scaledBoundary7 = 1000.0 / (double)this.zoom;
        double scaledBoundary8 = 2000.0 / (double)this.zoom;
        if (this.distanceToSignal > scaledMax) {
            ETCStools.renderElement(graphics, startTex, 0, CurrentY -= 9, 15, 9);
            for (int i = 0; i < 198; ++i) {
                ETCStools.renderElement(graphics, midTex, 0, --CurrentY, 15, 1);
            }
            posestack.m_85849_();
            return;
        }
        if (this.distanceToSignal > 100.0) {
            ETCStools.renderElement(graphics, startTex, 0, CurrentY -= 9, 15, 9);
        }
        double range1 = Math.min(scaledBoundary1, this.distanceToSignal);
        int pixelLength1 = (int)(range1 * 0.25 * (double)this.zoom);
        for (int i = 0; i < pixelLength1; ++i) {
            ETCStools.renderElement(graphics, midTex, 0, --CurrentY, 15, 1);
        }
        if (this.distanceToSignal <= scaledBoundary1) {
            ETCStools.renderElement(graphics, endTex, 0, CurrentY -= 9, 15, 9);
            ETCStools.renderElement(graphics, flagTex, 15, CurrentY, 19, 11);
            posestack.m_85849_();
            return;
        }
        double range2 = Math.min(scaledBoundary2, this.distanceToSignal) - scaledBoundary1;
        int pixelLength2 = (int)(range2 * 0.36 * (double)this.zoom);
        for (int i = 0; i < pixelLength2; ++i) {
            ETCStools.renderElement(graphics, midTex, 0, --CurrentY, 15, 1);
        }
        if (this.distanceToSignal <= scaledBoundary2) {
            ETCStools.renderElement(graphics, endTex, 0, CurrentY -= 9, 15, 9);
            ETCStools.renderElement(graphics, flagTex, 15, CurrentY, 19, 11);
            posestack.m_85849_();
            return;
        }
        double range3 = Math.min(scaledBoundary3, this.distanceToSignal) - scaledBoundary2;
        int pixelLength3 = (int)(range3 * 0.21 * (double)this.zoom);
        for (int i = 0; i < pixelLength3; ++i) {
            ETCStools.renderElement(graphics, midTex, 0, --CurrentY, 15, 1);
        }
        if (this.distanceToSignal <= scaledBoundary3) {
            ETCStools.renderElement(graphics, endTex, 0, CurrentY -= 9, 15, 9);
            ETCStools.renderElement(graphics, flagTex, 15, CurrentY, 19, 11);
            posestack.m_85849_();
            return;
        }
        double range4 = Math.min(scaledBoundary4, this.distanceToSignal) - scaledBoundary3;
        int pixelLength4 = (int)(range4 * 0.14 * (double)this.zoom);
        for (int i = 0; i < pixelLength4; ++i) {
            ETCStools.renderElement(graphics, midTex, 0, --CurrentY, 15, 1);
        }
        if (this.distanceToSignal <= scaledBoundary4) {
            ETCStools.renderElement(graphics, endTex, 0, CurrentY -= 9, 15, 9);
            ETCStools.renderElement(graphics, flagTex, 15, CurrentY, 19, 11);
            posestack.m_85849_();
            return;
        }
        double range5 = Math.min(scaledBoundary5, this.distanceToSignal) - scaledBoundary4;
        int pixelLength5 = (int)(range5 * 0.11 * (double)this.zoom);
        for (int i = 0; i < pixelLength5; ++i) {
            ETCStools.renderElement(graphics, midTex, 0, --CurrentY, 15, 1);
        }
        if (this.distanceToSignal <= scaledBoundary5) {
            ETCStools.renderElement(graphics, endTex, 0, CurrentY -= 9, 15, 9);
            ETCStools.renderElement(graphics, flagTex, 15, CurrentY, 19, 11);
            posestack.m_85849_();
            return;
        }
        double range6 = Math.min(scaledBoundary6, this.distanceToSignal) - scaledBoundary5;
        int pixelLength6 = (int)(range6 * 0.11 * (double)this.zoom);
        for (int i = 0; i < pixelLength6; ++i) {
            ETCStools.renderElement(graphics, midTex, 0, --CurrentY, 15, 1);
        }
        if (this.distanceToSignal <= scaledBoundary6) {
            ETCStools.renderElement(graphics, endTex, 0, CurrentY -= 9, 15, 9);
            ETCStools.renderElement(graphics, flagTex, 15, CurrentY, 19, 11);
            posestack.m_85849_();
            return;
        }
        double range7 = Math.min(scaledBoundary7, this.distanceToSignal) - scaledBoundary6;
        int pixelLength7 = (int)(range7 * 0.068 * (double)this.zoom);
        for (int i = 0; i < pixelLength7; ++i) {
            ETCStools.renderElement(graphics, midTex, 0, --CurrentY, 15, 1);
        }
        if (this.distanceToSignal <= scaledBoundary7) {
            ETCStools.renderElement(graphics, endTex, 0, CurrentY -= 9, 15, 9);
            ETCStools.renderElement(graphics, flagTex, 15, CurrentY, 19, 11);
            posestack.m_85849_();
            return;
        }
        double range8 = Math.min(scaledBoundary8, this.distanceToSignal) - scaledBoundary7;
        int pixelLength8 = (int)(range8 * 0.034 * (double)this.zoom);
        for (int i = 0; i < pixelLength8; ++i) {
            ETCStools.renderElement(graphics, midTex, 0, --CurrentY, 15, 1);
        }
        if (this.distanceToSignal <= scaledBoundary8) {
            ETCStools.renderElement(graphics, endTex, 0, CurrentY -= 9, 15, 9);
            ETCStools.renderElement(graphics, flagTex, 15, CurrentY, 19, 11);
            posestack.m_85849_();
            return;
        }
        double range9 = this.distanceToSignal - scaledBoundary8;
        int pixelLength9 = (int)(range9 * 0.017 * (double)this.zoom);
        for (int i = 0; i < pixelLength9; ++i) {
            ETCStools.renderElement(graphics, midTex, 0, --CurrentY, 15, 1);
        }
        ETCStools.renderElement(graphics, endTex, 0, CurrentY -= 9, 15, 9);
        ETCStools.renderElement(graphics, flagTex, 15, CurrentY, 19, 11);
        posestack.m_85849_();
    }

    public void renderBrakingCurve(GuiGraphics graphics, PoseStack poseStack, int xPos, int yPos) {
        int curveColor;
        boolean approachingBrakingZone;
        float currentSpeed = (float)Math.abs(this.train.speed * 20.0 * (double)3.6f);
        float distance = (float)this.distanceToSignal;
        double allowedSpeed = this.speedLimit;
        boolean bl = approachingBrakingZone = (double)distance <= this.cachedWarningBrakingDist * 1.5 + 100.0;
        if ((double)currentSpeed > this.speedLimit) {
            curveColor = -65536;
            ETCSsounds.startWarningLoop();
        } else if (this.cachedCurveIsDropping || approachingBrakingZone) {
            curveColor = -256;
            ETCSsounds.stopWarningLoop();
        } else {
            curveColor = -7829368;
            ETCSsounds.stopWarningLoop();
        }
        ETCStools.optimizedRenderSpeedCurve(graphics, poseStack, xPos + 155, yPos + 119, allowedSpeed, curveColor);
    }

    public void renderOverviewItems(GuiGraphics graphics, int xPos, int yPos, int zoom) {
        Font font = Minecraft.m_91087_().f_91062_;
        ResourceLocation flag = new ResourceLocation("realism:textures/flag.png");
        for (SpeedLimit s : this.cachedSpeedLimits) {
            if (s.distance() > this.distanceToSignal) continue;
            int pixelPos = this.calculateDistancePixelPosition(s.distance(), zoom);
            ETCStools.renderElement(graphics, flag, xPos + 386, yPos + 235 - pixelPos, 19, 11);
            graphics.m_280488_(font, String.valueOf((int)s.speedLimit()), xPos + 406, yPos + 235 - pixelPos, -1);
        }
        if (this.distanceToBrakingPoint > 0.0 && this.distanceToBrakingPoint < 4000.0 / (double)zoom) {
            int pixelPos = this.calculateDistancePixelPosition(this.distanceToBrakingPoint, zoom);
            graphics.m_280509_(xPos + 396, yPos + 235 - pixelPos, xPos + 471, yPos + 238 - pixelPos, -256);
        }
    }

    public int calculateDistancePixelPosition(double distance, int zoom) {
        int pixelPos = 0;
        double scaledMax = 4000.0 / (double)zoom;
        double scaledBoundary1 = 100.0 / (double)zoom;
        double scaledBoundary2 = 200.0 / (double)zoom;
        double scaledBoundary3 = 300.0 / (double)zoom;
        double scaledBoundary4 = 400.0 / (double)zoom;
        double scaledBoundary5 = 500.0 / (double)zoom;
        double scaledBoundary6 = 1000.0 / (double)zoom;
        double scaledBoundary7 = 2000.0 / (double)zoom;
        double scaledBoundary8 = 4000.0 / (double)zoom;
        if (distance > scaledMax) {
            return 198;
        }
        double range1 = Math.min(scaledBoundary1, distance);
        pixelPos += (int)(range1 * 0.25 * (double)zoom);
        if (distance <= scaledBoundary1) {
            return pixelPos;
        }
        double range2 = Math.min(scaledBoundary2, distance) - scaledBoundary1;
        pixelPos += (int)(range2 * 0.36 * (double)zoom);
        if (distance <= scaledBoundary2) {
            return pixelPos;
        }
        double range3 = Math.min(scaledBoundary3, distance) - scaledBoundary2;
        pixelPos += (int)(range3 * 0.21 * (double)zoom);
        if (distance <= scaledBoundary3) {
            return pixelPos;
        }
        double range4 = Math.min(scaledBoundary4, distance) - scaledBoundary3;
        pixelPos += (int)(range4 * 0.14 * (double)zoom);
        if (distance <= scaledBoundary4) {
            return pixelPos;
        }
        double range5 = Math.min(scaledBoundary5, distance) - scaledBoundary4;
        pixelPos += (int)(range5 * 0.11 * (double)zoom);
        if (distance <= scaledBoundary5) {
            return pixelPos;
        }
        double range6 = Math.min(scaledBoundary6, distance) - scaledBoundary5;
        pixelPos += (int)(range6 * 0.068 * (double)zoom);
        if (distance <= scaledBoundary6) {
            return pixelPos;
        }
        double range7 = Math.min(scaledBoundary7, distance) - scaledBoundary6;
        pixelPos += (int)(range7 * 0.034 * (double)zoom);
        if (distance <= scaledBoundary7) {
            return pixelPos;
        }
        double range8 = distance - scaledBoundary8;
        return pixelPos += (int)(range8 * 0.017 * (double)zoom);
    }

    private void markDirty() {
        this.needsSync = true;
    }

    private double calculateStoppingDistance(float speedKmh, float deceleration, float targetSpeedKmh) {
        float speedMs = speedKmh / 3.6f;
        float targetSpeedMs = targetSpeedKmh / 3.6f;
        return (speedMs * speedMs - targetSpeedMs * targetSpeedMs) / (2.0f * deceleration);
    }

    private int calculateAllowedSpeed(float distance, float maxDeceleration) {
        this.distanceToBrakingPoint = 9.99999999E8;
        float safetyFactor = 1.2f;
        float safeSpeed = (float)(Math.sqrt(2.0 * ((double)maxDeceleration * 0.9) * (double)distance) * 3.6);
        int distanctolimit = (int)distance;
        int targetspeedlimit = 0;
        int signalBasedSpeed = (int)(safeSpeed / safetyFactor);
        int limitBasedSpeed = Integer.MAX_VALUE;
        for (SpeedLimit speedLimit : this.cachedSpeedLimits) {
            if (speedLimit.distance() > 0.0 && speedLimit.distance() <= (double)distance * 1.5) {
                float distToLimit = (float)speedLimit.distance();
                float targetSpeed = (float)speedLimit.speedLimit() / 3.6f;
                float targetSpeedSq = targetSpeed * targetSpeed;
                safeSpeed = (float)(Math.sqrt((double)targetSpeedSq + 2.0 * ((double)maxDeceleration * 0.9) * (double)distToLimit) * 3.6);
                int adjustedLimit = (int)safeSpeed;
                if (adjustedLimit < limitBasedSpeed) {
                    limitBasedSpeed = adjustedLimit;
                    distanctolimit = (int)speedLimit.distance();
                    targetspeedlimit = (int)speedLimit.speedLimit();
                }
            }
            if (!(speedLimit.distance() < 5.0)) continue;
            this.trackspeedlimit = (int)speedLimit.speedLimit();
        }
        this.updateBrakingDistances(this.trackspeedlimit, targetspeedlimit);
        this.distanceToBrakingPoint = (double)distanctolimit - this.cachedServiceBrakingDist - 100.0;
        return limitBasedSpeed < Integer.MAX_VALUE ? Math.min(signalBasedSpeed, limitBasedSpeed) : signalBasedSpeed;
    }

    private void updateBrakingDistances(int currentSpeed, int targetspeed) {
        float maxDeceleration = this.train.acceleration() * 2.0f * 400.0f;
        this.cachedEmergencyBrakingDist = this.calculateStoppingDistance(currentSpeed, (float)((double)maxDeceleration * 1.0), targetspeed);
        this.cachedServiceBrakingDist = this.calculateStoppingDistance(currentSpeed, (float)((double)maxDeceleration * 0.9), targetspeed);
        this.cachedWarningBrakingDist = this.calculateStoppingDistance(currentSpeed, (float)((double)maxDeceleration * 0.5), targetspeed);
    }

    private void syncToClients() {
        if (this.train == null || !this.needsSync) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastSyncTime < 200L) {
            return;
        }
        this.lastSyncTime = currentTime;
        this.needsSync = false;
        if (((Carriage)this.train.carriages.get(0)).anyAvailableEntity() == null) {
            return;
        }
        Level level = ((Carriage)this.train.carriages.get(0)).anyAvailableEntity().m_9236_();
        if (level == null || level.m_5776_()) {
            return;
        }
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return;
        }
        ETCSSyncPacket packet = new ETCSSyncPacket(this.train.id, this.distanceToSignal, this.speedLimit, this.needleRotationDegrees, this.backward, this.cachedEmergencyBrakingDist, this.cachedServiceBrakingDist, this.cachedWarningBrakingDist, this.cachedCurveIsDropping, this.cachedSpeedLimits, this.zoom, this.pendingBeepSound, this.distanceToBrakingPoint, this.toUpdate);
        RNetworking.sendToAll(packet);
        this.pendingBeepSound = false;
    }

    public void updateFromNetwork(double distanceToSignal, double speedLimit, float needleRotation, boolean backward, double emergencyBrakingDist, double serviceBrakingDist, double warningBrakingDist, boolean curveIsDropping, List<SpeedLimit> speedLimits, int zoom, boolean newRouteSound, double distanceToBrakingPoint, boolean toUpdate) {
        this.distanceToSignal = distanceToSignal;
        this.speedLimit = speedLimit;
        this.needleRotationDegrees = needleRotation;
        this.backward = backward;
        this.cachedSpeedLimits = new ArrayList<SpeedLimit>(speedLimits);
        this.cachedEmergencyBrakingDist = emergencyBrakingDist;
        this.cachedServiceBrakingDist = serviceBrakingDist;
        this.cachedWarningBrakingDist = warningBrakingDist;
        this.cachedCurveIsDropping = curveIsDropping;
        this.zoom = zoom;
        this.distanceToBrakingPoint = distanceToBrakingPoint;
        this.pendingBeepSound = newRouteSound;
        this.lastUpdateTime = System.currentTimeMillis();
        this.needsSync = false;
        this.toUpdate = toUpdate;
    }

    public CompoundTag saveToNBT() {
        if (this.train == null) {
            return null;
        }
        CompoundTag etcsData = new CompoundTag();
        etcsData.m_128347_("distanceToSignal", this.distanceToSignal);
        etcsData.m_128347_("speedLimit", this.speedLimit);
        etcsData.m_128350_("needleRotation", this.needleRotationDegrees);
        etcsData.m_128379_("backward", this.backward);
        etcsData.m_128379_("previousBackward", this.previousBackward);
        etcsData.m_128356_("lastUpdateTime", this.lastUpdateTime);
        etcsData.m_128347_("emergencyBrakingDist", this.cachedEmergencyBrakingDist);
        etcsData.m_128347_("serviceBrakingDist", this.cachedServiceBrakingDist);
        etcsData.m_128347_("warningBrakingDist", this.cachedWarningBrakingDist);
        etcsData.m_128379_("curveIsDropping", this.cachedCurveIsDropping);
        etcsData.m_128347_("allowedSpeed", this.cachedAllowedSpeed);
        etcsData.m_128405_("zoom", this.zoom);
        etcsData.m_128405_("trackspeedlimit", this.trackspeedlimit);
        CompoundTag speedLimitsTag = new CompoundTag();
        speedLimitsTag.m_128405_("size", this.cachedSpeedLimits.size());
        for (int i = 0; i < this.cachedSpeedLimits.size(); ++i) {
            SpeedLimit limit = this.cachedSpeedLimits.get(i);
            CompoundTag limitTag = new CompoundTag();
            limitTag.m_128347_("distance", limit.distance());
            limitTag.m_128347_("speed", limit.speedLimit());
            speedLimitsTag.m_128365_("limit" + i, (Tag)limitTag);
        }
        etcsData.m_128365_("speedLimits", (Tag)speedLimitsTag);
        return etcsData;
    }

    public void loadFromNBT(CompoundTag etcsData) {
        if (this.train == null) {
            return;
        }
        this.distanceToSignal = etcsData.m_128459_("distanceToSignal");
        this.speedLimit = etcsData.m_128459_("speedLimit");
        this.needleRotationDegrees = etcsData.m_128457_("needleRotation");
        this.backward = etcsData.m_128471_("backward");
        this.previousBackward = etcsData.m_128471_("previousBackward");
        this.lastUpdateTime = etcsData.m_128454_("lastUpdateTime");
        this.cachedEmergencyBrakingDist = etcsData.m_128459_("emergencyBrakingDist");
        this.cachedServiceBrakingDist = etcsData.m_128459_("serviceBrakingDist");
        this.cachedWarningBrakingDist = etcsData.m_128459_("warningBrakingDist");
        this.cachedCurveIsDropping = etcsData.m_128471_("curveIsDropping");
        this.cachedAllowedSpeed = etcsData.m_128459_("allowedSpeed");
        this.zoom = etcsData.m_128451_("zoom");
        this.trackspeedlimit = etcsData.m_128451_("trackspeedlimit");
        if (etcsData.m_128441_("speedLimits")) {
            CompoundTag speedLimitsTag = etcsData.m_128469_("speedLimits");
            int size = speedLimitsTag.m_128451_("size");
            this.cachedSpeedLimits = new ArrayList<SpeedLimit>(size);
            for (int i = 0; i < size; ++i) {
                CompoundTag limitTag = speedLimitsTag.m_128469_("limit" + i);
                double distance = limitTag.m_128459_("distance");
                double speed = limitTag.m_128459_("speed");
                this.cachedSpeedLimits.add(new SpeedLimit(distance, speed));
            }
        }
    }

    private void sendKeysToServer() {
        boolean plusKeyDown = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)61);
        boolean minusKeyDown = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)45);
        long currentTime = System.currentTimeMillis();
        if (plusKeyDown && !this.plusKeyWasDown && currentTime - this.lastKeyPressTime > 300L) {
            RNetworking.sendToServer(new SteerDirectionPacket(SteerDirectionPacket.KeyPressType.PLUS));
            this.lastKeyPressTime = currentTime;
        } else if (minusKeyDown && !this.minusKeyWasDown && currentTime - this.lastKeyPressTime > 300L) {
            RNetworking.sendToServer(new SteerDirectionPacket(SteerDirectionPacket.KeyPressType.MINUS));
            this.lastKeyPressTime = currentTime;
        } else if (!plusKeyDown && !minusKeyDown) {
            RNetworking.sendToServer(new SteerDirectionPacket(SteerDirectionPacket.KeyPressType.NONE));
        }
        this.plusKeyWasDown = plusKeyDown;
        this.minusKeyWasDown = minusKeyDown;
    }

    private void ReciveKeys() {
        Optional<UUID> controllingPlayerUuid = this.train.carriages.stream().flatMap(carriage -> {
            CarriageContraptionEntity entity = carriage.anyAvailableEntity();
            return entity != null ? Stream.of(entity.getControllingPlayer()) : Stream.empty();
        }).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (!controllingPlayerUuid.isPresent()) {
            return;
        }
        SteerDirectionPacket.KeyPressType currentKeyPress = SteerDirectionPacket.getPlayerKeyPress(controllingPlayerUuid.get());
        if (this.zoom == 0) {
            this.zoom = 1;
        }
        switch (currentKeyPress) {
            case PLUS: {
                if (this.zoom >= 4) break;
                this.zoom *= 2;
                SteerDirectionPacket.setPlayerKeyPresses(controllingPlayerUuid.get(), SteerDirectionPacket.KeyPressType.NONE);
                break;
            }
            case MINUS: {
                if (this.zoom <= 1) break;
                this.zoom /= 2;
                SteerDirectionPacket.setPlayerKeyPresses(controllingPlayerUuid.get(), SteerDirectionPacket.KeyPressType.NONE);
            }
        }
    }

    public record SpeedLimit(double distance, double speedLimit) {
    }
}

