/*
 * Decompiled with CFR 0.152.
 */
package net.Realism.trains.etcs;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class ETCStools {
    public static float calculateNeedleRotation(double trainSpeed) {
        float speedKmh = (float)Math.abs(trainSpeed * 20.0 * (double)3.6f);
        float rotationDegrees = speedKmh <= 160.0f ? -151.5f + 1.134f * speedKmh : 30.0f + 0.671f * (speedKmh - 160.0f);
        return rotationDegrees;
    }

    public static void renderElement(GuiGraphics graphics, ResourceLocation path, int x, int y, int width, int height) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)path);
        graphics.m_280163_(path, x, y, 0.0f, 0.0f, width, height, width, height);
    }

    public static void optimizedRenderSpeedCurve(GuiGraphics graphics, PoseStack poseStack, int centerX, int centerY, double maxSpeed, int color) {
        int radius = 115;
        int arcWidth = 7;
        float startAngleRad = -4.0753436f;
        if (maxSpeed > 300.0) {
            maxSpeed = 300.0;
        }
        float endAngleRad = maxSpeed <= 160.0 ? (float)((-233.5 + (double)1.134f * maxSpeed) * 0.01745329238474369) : (float)((-50.0 + (double)0.671f * (maxSpeed - 160.0)) * 0.01745329238474369);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        int segments = 64;
        poseStack.m_85836_();
        poseStack.m_252880_((float)centerX, (float)centerY, 0.0f);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        for (int i = 0; i <= segments; ++i) {
            float ratio = (float)i / (float)segments;
            float angle = startAngleRad + (endAngleRad - startAngleRad) * ratio;
            float cos = (float)Math.cos(angle);
            float sin = (float)Math.sin(angle);
            float outerX = cos * (float)radius;
            float outerY = sin * (float)radius;
            buffer.m_252986_(matrix, outerX, outerY, 0.0f).m_85950_(r, g, b, a).m_5752_();
            float innerX = cos * (float)(radius - arcWidth);
            float innerY = sin * (float)(radius - arcWidth);
            buffer.m_252986_(matrix, innerX, innerY, 0.0f).m_85950_(r, g, b, a).m_5752_();
        }
        tesselator.m_85914_();
        float endX = (float)Math.cos(endAngleRad) * ((float)radius - (float)arcWidth / 2.0f);
        float endY = (float)Math.sin(endAngleRad) * ((float)radius - (float)arcWidth / 2.0f);
        float innerEndX = (float)Math.cos(endAngleRad) * (float)(radius - arcWidth - 16);
        float innerEndY = (float)Math.sin(endAngleRad) * (float)(radius - arcWidth - 16);
        float perpX = -(endY - innerEndY);
        float perpY = endX - innerEndX;
        float perpLen = (float)Math.sqrt(perpX * perpX + perpY * perpY);
        perpX = perpX / perpLen * 2.0f;
        perpY = perpY / perpLen * 2.0f;
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        buffer.m_252986_(matrix, endX + perpX, endY + perpY, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, endX - perpX, endY - perpY, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, innerEndX + perpX, innerEndY + perpY, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, innerEndX - perpX, innerEndY - perpY, 0.0f).m_85950_(r, g, b, a).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }
}

