/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.invisibleframes;

import games.enchanted.invisibleframes.duck.InvisibleFramesAccess;
import games.enchanted.invisibleframes.mixin.access.DisplayAccess;
import games.enchanted.invisibleframes.mixin.access.HangingEntityAccess;
import games.enchanted.invisibleframes.mixin.access.TextDisplayAccess;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1533;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2675;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4590;
import net.minecraft.class_5819;
import net.minecraft.class_5915;
import net.minecraft.class_7833;
import net.minecraft.class_8104;
import net.minecraft.class_8113;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ItemFrameGhostManager {
    private static final int FADE_OUT_TICKS = 25;
    private static final int FADE_OUT_DELAY = 7;
    private static final int STARTING_COLOUR = -504109091;
    private static final int ENDING_COLOUR = 15984605;
    private final class_1533 itemFrame;
    private final class_3218 level;
    @Nullable
    private class_8113.class_8123 display;
    private int timeAlive = 0;

    public ItemFrameGhostManager(class_1533 itemFrame, class_3218 level) {
        this.itemFrame = itemFrame;
        this.level = level;
    }

    public void tick() {
        if (this.timeAlive <= 1 && !((InvisibleFramesAccess)this.itemFrame).invisibleFrames$getInvisibleItem().method_7960() && this.itemFrame.method_5767() && this.itemFrame.method_6940().method_7960() && this.itemFrame.method_59922().method_43048(30) == 0) {
            this.spawnRandomParticle();
        }
        if (this.display == null) {
            return;
        }
        ++this.timeAlive;
        if (this.timeAlive > 1) {
            double d = this.itemFrame.method_59922().method_43057();
            double d2 = this.itemFrame.method_6940().method_7960() ? 1.0 : 2.5;
            if (d * d2 + 0.2 < (double)this.getPercentageTimeAlive()) {
                this.spawnRandomParticle();
            }
        }
        if (this.timeAlive == 1) {
            ((TextDisplayAccess)this.display).invisibleFrames$setBackgroundColor(15984605);
        }
        if (this.timeAlive >= 32) {
            this.resetState();
        }
    }

    private float getPercentageTimeAlive() {
        return (float)this.timeAlive / 32.0f;
    }

    public void resetState() {
        if (this.display != null) {
            this.display.method_31472();
            this.display = null;
            this.timeAlive = 0;
        }
    }

    public void createGhost() {
        float yRot;
        float xRot;
        if (this.display != null) {
            this.resetState();
        }
        class_2350 direction = this.itemFrame.method_5735();
        this.display = new class_8113.class_8123(class_1299.field_42457, (class_1937)this.level);
        this.display.method_5814(this.itemFrame.method_23317() + (double)(-0.03f * (float)direction.method_10148()), this.itemFrame.method_23318() + (double)(-0.03f * (float)direction.method_10164()), this.itemFrame.method_23321() + (double)(-0.03f * (float)direction.method_10165()));
        if (direction.method_10166().method_10179()) {
            xRot = 0.0f;
            yRot = 180.0f - direction.method_10153().method_10144();
        } else {
            xRot = 90 * direction.method_10171().method_10181();
            yRot = 180.0f;
        }
        Quaternionf rotationQuaternion = class_7833.field_40714.rotationDegrees(xRot);
        rotationQuaternion.mul((Quaternionfc)class_7833.field_40716.rotationDegrees(yRot));
        ((DisplayAccess)this.display).invisibleFrames$setTransformation(new class_4590(new Vector3f(-0.075f, -0.37f, 0.0f).rotate((Quaternionfc)rotationQuaternion), rotationQuaternion, new Vector3f(6.0f, 3.0f, 6.0f), new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f)));
        ((TextDisplayAccess)this.display).invisibleFrames$setText((class_2561)class_2561.method_43470((String)" "));
        ((DisplayAccess)this.display).invisibleFrames$setInterpolationDuration(25);
        ((DisplayAccess)this.display).invisibleFrames$setInterpolationDelay(7);
        ((TextDisplayAccess)this.display).invisibleFrames$setBackgroundColor(-504109091);
        if (this.itemFrame instanceof class_5915) {
            ((DisplayAccess)this.display).invisibleFrames$setBrightness(class_8104.field_42264);
        }
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10556("eg_invisible_frames:prevent_saving", true);
        this.display.method_66653(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)compoundTag));
        this.level.method_8649((class_1297)this.display);
    }

    public void spawnRandomParticle() {
        class_5819 random = this.itemFrame.method_59922();
        class_238 boundingBox = this.itemFrame.method_5829().method_1011(0.1);
        class_2350 frameDirection = (class_2350)this.itemFrame.method_5841().method_12789(((HangingEntityAccess)this.itemFrame).invisible_frames$getDirection());
        double x = (double)random.method_43057() * boundingBox.method_17939();
        double y = (double)random.method_43057() * boundingBox.method_17940();
        double z = (double)random.method_43057() * boundingBox.method_17941();
        x += boundingBox.field_1323;
        y += boundingBox.field_1322;
        z += boundingBox.field_1321;
        if (frameDirection != class_2350.field_11033) {
            y += 0.125;
        }
        for (class_3222 player : ((InvisibleFramesAccess)this.itemFrame).invisibleFrames$getTrackedPlayers()) {
            if (player.method_5739((class_1297)this.itemFrame) > 15.0f && player.method_6057((class_1297)this.itemFrame)) {
                return;
            }
            player.field_13987.method_14364((class_2596)new class_2675((class_2394)class_2398.field_11207, false, true, x, y, z, 0.0f, 0.0f, 0.0f, 0.0f, 1));
        }
    }
}

