/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.splinecart.block;

import io.github.foundationgames.splinecart.Splinecart;
import io.github.foundationgames.splinecart.block.TrackMarkerBlock;
import io.github.foundationgames.splinecart.block.TrackMarkerTriggers;
import io.github.foundationgames.splinecart.track.TrackColor;
import io.github.foundationgames.splinecart.track.TrackColorPreset;
import io.github.foundationgames.splinecart.track.TrackStyle;
import io.github.foundationgames.splinecart.track.TrackType;
import io.github.foundationgames.splinecart.util.Pose;
import io.github.foundationgames.splinecart.util.SUtil;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class TrackMarkerBlockEntity
extends class_2586 {
    public static final int ORIENTATION_RESOLUTION = 360;
    public float clientTime = 0.0f;
    public TrackType nextType = TrackType.DEFAULT;
    public TrackStyle nextStyle = TrackStyle.DEFAULT;
    public TrackColor nextColor = TrackColorPreset.WHITE.get();
    @Nullable
    private class_2338 nextTrackMarkerPos = null;
    @Nullable
    private class_2338 prevTrackMarkerPos = null;
    private Pose pose;
    private int power = Integer.MAX_VALUE;
    private int strength = Integer.MAX_VALUE;
    public TrackMarkerTriggers triggers = new TrackMarkerTriggers();
    private double lastVelocity = 0.0;
    public int heading = Integer.MAX_VALUE;
    public int pitching = 0;
    public int banking = 0;
    public int relative_orientation = 0;

    public TrackMarkerBlockEntity(class_2338 pos, class_2680 state) {
        super(Splinecart.TRACK_TIES_BE, pos, state);
        this.updatePose();
    }

    public void updatePose() {
        class_2338 blockPos = this.method_11016();
        this.updateHeadingFromBlock();
        Vector3d pos = new Vector3d((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5);
        Matrix3d basis = new Matrix3d();
        basis.rotateY((double)((float)(-this.heading) * (float)Math.PI) * 0.005555555555555556);
        basis.rotateX((double)((float)(-this.pitching) * (float)Math.PI) * 0.005555555555555556);
        basis.rotateY((double)((float)(-this.relative_orientation) * (float)Math.PI) * 0.005555555555555556);
        basis.rotateZ((double)((float)(-this.banking) * (float)Math.PI) * 0.005555555555555556);
        this.pose = new Pose((Vector3dc)pos, (Matrix3dc)basis);
    }

    public void method_31664(class_2680 state) {
        super.method_31664(state);
        this.updatePose();
    }

    @Nullable
    public static TrackMarkerBlockEntity of(class_1937 world, @Nullable class_2338 pos) {
        class_2586 class_25862;
        if (pos != null && (class_25862 = world.method_8321(pos)) instanceof TrackMarkerBlockEntity) {
            TrackMarkerBlockEntity e = (TrackMarkerBlockEntity)class_25862;
            return e;
        }
        return null;
    }

    public void setNext(@Nullable class_2338 pos) {
        TrackMarkerBlockEntity nextMarker;
        this.removeNextMarker();
        this.nextTrackMarkerPos = pos;
        TrackMarkerBlockEntity prevMarker = this.getPrevMarker();
        if (prevMarker != null) {
            this.nextColor = prevMarker.nextColor;
            this.nextStyle = prevMarker.nextStyle;
            this.nextType = prevMarker.nextType;
        }
        if ((nextMarker = this.getNextMarker()) != null) {
            TrackMarkerBlockEntity nextPrevMarker = nextMarker.getPrevMarker();
            nextMarker.removePrevMarker();
            if (nextPrevMarker != null) {
                nextPrevMarker.sync();
                nextPrevMarker.method_5431();
            }
            nextMarker.prevTrackMarkerPos = this.method_11016();
            nextMarker.sync();
            nextMarker.method_5431();
        }
        this.sync();
        this.method_5431();
    }

    public void removePrevMarker() {
        if (this.getPrevMarker() != null) {
            this.getPrevMarker().setNextTrackMarkerPos(null);
        }
        this.prevTrackMarkerPos = null;
    }

    public void removeNextMarker() {
        if (this.getNextMarker() != null) {
            this.getNextMarker().setPrevTrackMarkerPos(null);
        }
        this.nextTrackMarkerPos = null;
    }

    @Nullable
    public TrackMarkerBlockEntity getNextMarker() {
        assert (this.field_11863 != null);
        return this.nextTrackMarkerPos == null ? null : (TrackMarkerBlockEntity)this.field_11863.method_8321(this.nextTrackMarkerPos);
    }

    @Nullable
    public TrackMarkerBlockEntity getPrevMarker() {
        assert (this.field_11863 != null);
        return this.prevTrackMarkerPos == null ? null : (TrackMarkerBlockEntity)this.field_11863.method_8321(this.prevTrackMarkerPos);
    }

    @Nullable
    public class_2338 getNextTrackMarkerPos() {
        return this.nextTrackMarkerPos;
    }

    public void setNextTrackMarkerPos(@Nullable class_2338 nextTrackMarkerPos) {
        this.nextTrackMarkerPos = nextTrackMarkerPos;
    }

    @Nullable
    public class_2338 getPrevTrackMarkerPos() {
        return this.prevTrackMarkerPos;
    }

    public void setPrevTrackMarkerPos(@Nullable class_2338 prevTrackMarkerPos) {
        this.prevTrackMarkerPos = prevTrackMarkerPos;
    }

    public boolean hasNoTrackConnected() {
        return this.prevTrackMarkerPos == null && this.nextTrackMarkerPos == null;
    }

    public int getPower() {
        return this.power;
    }

    public void setPower(int power) {
        this.power = power;
    }

    public int computePower() {
        TrackMarkerBlockEntity marker = this;
        int counter = 0;
        do {
            if (marker.power == Integer.MAX_VALUE) continue;
            return marker.power;
        } while ((marker = marker.getPrevMarker()) != null && marker != this && ++counter < 100);
        return 0;
    }

    public int getStrength() {
        return this.strength;
    }

    public void setStrength(int strength) {
        this.strength = strength;
    }

    public int computeStrength() {
        TrackMarkerBlockEntity marker = this;
        int counter = 0;
        do {
            if (marker.strength == Integer.MAX_VALUE) continue;
            return marker.strength;
        } while ((marker = marker.getPrevMarker()) != null && marker != this && ++counter < 100);
        return 100;
    }

    public double computeLastVelocity() {
        return this.lastVelocity > 0.0 && this.nextTrackMarkerPos != null || this.lastVelocity < 0.0 && this.prevTrackMarkerPos != null ? this.lastVelocity : 0.0;
    }

    public void setLastVelocity(double lastVelocity) {
        this.lastVelocity = lastVelocity;
    }

    public Pose pose() {
        this.updatePose();
        return this.pose;
    }

    public void onDestroy() {
        TrackMarkerBlockEntity nextMarker;
        TrackMarkerBlockEntity prevMarker = this.getPrevMarker();
        if (prevMarker != null) {
            prevMarker.nextTrackMarkerPos = null;
            prevMarker.sync();
            prevMarker.method_5431();
        }
        if ((nextMarker = this.getNextMarker()) != null) {
            nextMarker.prevTrackMarkerPos = null;
            nextMarker.sync();
            nextMarker.method_5431();
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        assert (this.field_11863 != null);
        this.prevTrackMarkerPos = SUtil.getBlockPos(nbt, "prev");
        this.nextTrackMarkerPos = SUtil.getBlockPos(nbt, "next");
        this.nextType = TrackType.read(nbt.method_10550("track_type"));
        this.nextStyle = TrackStyle.read(nbt.method_10550("track_style"));
        this.nextColor = new TrackColor(nbt.method_10550("track_color"));
        this.power = nbt.method_10550("power");
        this.strength = nbt.method_10550("strength");
        this.triggers = new TrackMarkerTriggers((class_2499)nbt.method_10580("triggers"));
        this.lastVelocity = nbt.method_10574("last_velocity");
        this.heading = nbt.method_10550("heading");
        this.pitching = nbt.method_10550("pitching");
        this.banking = nbt.method_10550("banking");
        this.relative_orientation = nbt.method_10550("relative_orientation");
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        SUtil.putBlockPos(nbt, this.getPrevTrackMarkerPos(), "prev");
        SUtil.putBlockPos(nbt, this.getNextTrackMarkerPos(), "next");
        nbt.method_10569("track_type", this.nextType.ordinal());
        nbt.method_10569("track_style", this.nextStyle.ordinal());
        nbt.method_10569("track_color", this.nextColor.hex());
        nbt.method_10569("power", this.power);
        nbt.method_10569("strength", this.strength);
        nbt.method_10566("triggers", (class_2520)this.triggers.getNbt());
        nbt.method_10549("last_velocity", this.lastVelocity);
        this.updateHeadingFromBlock();
        nbt.method_10569("heading", this.heading);
        nbt.method_10569("pitching", this.pitching);
        nbt.method_10569("banking", this.banking);
        nbt.method_10569("relative_orientation", this.relative_orientation);
    }

    private void updateHeadingFromBlock() {
        class_2248 class_22482;
        if (this.heading == Integer.MAX_VALUE && this.field_11863 != null && (class_22482 = this.field_11863.method_8320(this.method_11016()).method_26204()) instanceof TrackMarkerBlock) {
            TrackMarkerBlock block = (TrackMarkerBlock)class_22482;
            if (block.itemPlacementContext != null) {
                if (block.itemPlacementContext.method_8036() == null) {
                    return;
                }
                this.heading = block.itemPlacementContext.method_8036().method_5715() ? TrackMarkerBlockEntity.round((int)block.itemPlacementContext.method_8044(), 5) % 360 : TrackMarkerBlockEntity.round((int)block.itemPlacementContext.method_8044(), 45) % 360;
                this.method_5431();
            }
        }
    }

    private static int round(int value, int increment) {
        return (value + 360 + increment / 2) / increment * increment;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbt = super.method_16887(registryLookup);
        this.method_11007(nbt, registryLookup);
        return nbt;
    }

    public void sync() {
        Objects.requireNonNull(this.method_10997()).method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }
}

