/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.splinecart.block;

import io.github.foundationgames.splinecart.Splinecart;
import io.github.foundationgames.splinecart.block.TrackMarkerBlockEntity;
import io.github.foundationgames.splinecart.item.tools.PowerToolItem;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;

public class TrackMarkerTrigger {
    private final class_2338 location;
    private final int power;
    private final int strength;

    public TrackMarkerTrigger(class_2487 compound) {
        this.location = new class_2338(compound.method_10550("x"), compound.method_10550("y"), compound.method_10550("z"));
        this.power = compound.method_10550("power");
        this.strength = compound.method_10550("strength");
    }

    public TrackMarkerTrigger(TrackMarkerBlockEntity marker) {
        this.location = marker.method_11016();
        this.power = marker.getPower();
        this.strength = marker.getStrength();
    }

    public TrackMarkerTrigger(class_2338 location, int power, int strength) {
        this.location = location;
        this.power = power;
        this.strength = strength;
    }

    public boolean execute(class_1937 world) {
        class_2586 class_25862 = world.method_8321(this.location);
        if (class_25862 instanceof TrackMarkerBlockEntity) {
            TrackMarkerBlockEntity marker = (TrackMarkerBlockEntity)class_25862;
            if (marker.getPower() == this.power && marker.getStrength() == this.strength) {
                this.sendWarning(world);
                return true;
            }
            marker.setPower(this.power);
            marker.setStrength(this.strength);
            marker.method_5431();
            marker.sync();
            this.sendStatus(world);
            return true;
        }
        this.sendError(world);
        return false;
    }

    private void sendError(class_1937 world) {
        TrackMarkerTrigger.broadcastMessage(world, class_2561.method_30163((String)("[TRIGGER] No marker at location " + this.location.method_23854())));
    }

    private void sendWarning(class_1937 world) {
        TrackMarkerTrigger.broadcastMessage(world, class_2561.method_30163((String)("[TRIGGER] Nothing changed at " + this.getDisplayString("(%d, %d, %d) p: %s s: %s"))));
    }

    private void sendStatus(class_1937 world) {
        TrackMarkerTrigger.broadcastMessage(world, class_2561.method_30163((String)("[TRIGGER] Successfully updated " + this.getDisplayString("(%d, %d, %d) p: %s s: %s"))));
    }

    private static void broadcastMessage(class_1937 world, class_2561 text) {
        class_3218 serverWorld;
        if (world instanceof class_3218 && (serverWorld = (class_3218)world).method_64395().method_8355(Splinecart.TRIGGER_OUTPUT)) {
            serverWorld.method_18456().forEach(player -> player.method_64398(text));
        }
    }

    public class_2487 getNbt() {
        class_2487 compound = new class_2487();
        compound.method_10569("x", this.location.method_10263());
        compound.method_10569("y", this.location.method_10264());
        compound.method_10569("z", this.location.method_10260());
        compound.method_10569("power", this.power);
        compound.method_10569("strength", this.strength);
        return compound;
    }

    public String getDisplayString(String format) {
        return String.format(format, this.location.method_10263(), this.location.method_10264(), this.location.method_10260(), this.power == Integer.MAX_VALUE ? "unset" : PowerToolItem.toFixedPointRepresentation(this.power), this.strength == Integer.MAX_VALUE ? "unset" : PowerToolItem.toFixedPointRepresentation(this.strength));
    }

    public class_2338 getLocation() {
        return this.location;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TrackMarkerTrigger) {
            TrackMarkerTrigger other = (TrackMarkerTrigger)obj;
            return this.location.equals((Object)other.location) && this.strength == other.strength && this.power == other.power;
        }
        return false;
    }
}

