/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.splinecart.block.entity;

import io.github.foundationgames.splinecart.Splinecart;
import io.github.foundationgames.splinecart.SplinecartClient;
import io.github.foundationgames.splinecart.block.TrackMarkerBlockEntity;
import io.github.foundationgames.splinecart.track.TrackStyle;
import io.github.foundationgames.splinecart.track.TrackType;
import io.github.foundationgames.splinecart.util.Pose;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_827;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class TrackTiesBlockEntityRenderer
implements class_827<TrackMarkerBlockEntity> {
    public static final int WHITE = -1;
    public static final Vector3f WHITE_FLOAT = new Vector3f(1.0f, 1.0f, 1.0f);
    public static final class_2960 TRACK_TEXTURE = Splinecart.id("textures/track/track.png");
    public static final class_2960 TRACK_ANIMATION_OVERLAY_TEXTURE = Splinecart.id("textures/track/track_animation_overlay.png");
    public static final class_2960 TRACK_OVERLAY_TEXTURE = Splinecart.id("textures/track/track_overlay.png");
    public static final class_2960 POSE_TEXTURE_DEBUG = Splinecart.id("textures/track/debug.png");

    public TrackTiesBlockEntityRenderer(class_5614.class_5615 ignoredCtx) {
    }

    public void render(TrackMarkerBlockEntity marker, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        Pose pose = marker.pose();
        class_2338 pos = marker.method_11016();
        if (!(marker.method_10997().method_8321(pos) instanceof TrackMarkerBlockEntity)) {
            return;
        }
        marker.clientTime += tickDelta;
        if (marker.hasNoTrackConnected() || class_310.method_1498() && (((Boolean)SplinecartClient.CFG_SHOW_DEBUG.get()).booleanValue() || class_310.method_1551().method_53526().method_53536())) {
            this.renderDebugPre(matrices, vertexConsumers, pose);
        }
        class_4588 buffer = vertexConsumers.getBuffer(class_1921.method_23578((class_2960)TRACK_TEXTURE));
        TrackMarkerBlockEntity nextMarker = marker.getNextMarker();
        if (nextMarker == null) {
            return;
        }
        Pose nextMarkerPose = nextMarker.pose();
        class_1937 world = marker.method_10997();
        matrices.method_22903();
        matrices.method_46416((float)(-pos.method_10263()), (float)(-pos.method_10264()), (float)(-pos.method_10260()));
        TrackStyle trackStyle = marker.nextStyle;
        float u0 = (float)trackStyle.ordinal() * 0.125f;
        float u1 = u0 + 0.125f;
        int segments = (Integer)SplinecartClient.CFG_TRACK_RESOLUTION.get() * Math.max((int)pose.translation().distance(nextMarkerPose.translation()), 2);
        Vector3d origin = new Vector3d(pose.translation());
        Matrix3d basis = new Matrix3d(pose.basis());
        Vector3d grad = new Vector3d(0.0, 0.0, 1.0).mul(pose.basis());
        double[] totalDist = new double[]{0.0};
        for (int i = 0; i < segments; ++i) {
            double t0 = (double)i / (double)segments;
            double t1 = (double)(i + 1) / (double)segments;
            this.renderPart(world, matrices.method_23760(), buffer, pose, nextMarkerPose, u0, u1, 0.0f, marker.nextColor.getVec3f(), t0, t1, totalDist, origin, basis, grad, overlay);
        }
        TrackType trackType = marker.nextType;
        if (trackType.overlay != null) {
            u0 = (float)trackType.ordinal() * 0.25f;
            u1 = u0 + 0.25f;
            class_4588 olBuffer = vertexConsumers.getBuffer(class_1921.method_23578((class_2960)TRACK_OVERLAY_TEXTURE));
            float[] olVOffset = new float[]{0.0f};
            Vector3f olColor = new Vector3f((Vector3fc)WHITE_FLOAT);
            for (int i = 0; i < segments; ++i) {
                double t0 = (double)i / (double)segments;
                double t1 = (double)(i + 1) / (double)segments;
                this.renderPart(world, matrices.method_23760(), olBuffer, pose, nextMarkerPose, u0, u1, olVOffset[0], olColor, t0, t1, totalDist, origin, basis, grad, overlay);
            }
            olBuffer = vertexConsumers.getBuffer(class_1921.method_23578((class_2960)TRACK_ANIMATION_OVERLAY_TEXTURE));
            olVOffset = new float[]{0.0f};
            olColor = new Vector3f((Vector3fc)WHITE_FLOAT);
            int power = marker.computePower();
            trackType.overlay.calculateEffects(power, marker.clientTime, olColor, olVOffset);
            for (int i = 0; i < segments; ++i) {
                double t0 = (double)i / (double)segments;
                double t1 = (double)(i + 1) / (double)segments;
                this.renderPart(world, matrices.method_23760(), olBuffer, pose, nextMarkerPose, u0, u1, olVOffset[0], olColor, t0, t1, totalDist, origin, basis, grad, overlay);
            }
        }
        matrices.method_22909();
    }

    public boolean rendersOutsideBoundingBox(TrackMarkerBlockEntity blockEntity) {
        return true;
    }

    public int method_33893() {
        return (Integer)SplinecartClient.CFG_TRACK_RENDER_DISTANCE.get() * 16;
    }

    private void renderDebugPre(class_4587 matrices, class_4597 vertexConsumers, Pose start) {
        matrices.method_22903();
        matrices.method_22904(0.51, 0.511, 0.512);
        class_4588 buffer = vertexConsumers.getBuffer(class_1921.method_23578((class_2960)POSE_TEXTURE_DEBUG));
        this.renderDebug(start, matrices.method_23760(), buffer);
        matrices.method_22909();
    }

    private void renderDebug(Pose pose, class_4587.class_4665 entry, class_4588 buffer) {
        Matrix4f posMat = entry.method_23761();
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                posMat.setRowColumn(x, y, (float)pose.basis().getRowColumn(x, y));
            }
        }
        buffer.method_56824(entry, 1.0f, 0.0f, 1.0f).method_39415(-1).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(entry, 0.0f, 1.0f, 0.0f);
        buffer.method_56824(entry, 0.0f, 0.0f, 1.0f).method_39415(-1).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(entry, 0.0f, 1.0f, 0.0f);
        buffer.method_56824(entry, 0.0f, 0.0f, 0.0f).method_39415(-1).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(entry, 0.0f, 1.0f, 0.0f);
        buffer.method_56824(entry, 1.0f, 0.0f, 0.0f).method_39415(-1).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(entry, 0.0f, 1.0f, 0.0f);
    }

    private void renderPart(class_1937 world, class_4587.class_4665 entry, class_4588 buffer, Pose start, Pose end, float u0, float u1, float vOffset, Vector3f color, double t0, double t1, double[] blockProgress, Vector3d origin0, Matrix3d basis0, Vector3d grad0, int overlay) {
        float v0;
        start.interpolate(end, t0, origin0, basis0, grad0);
        Vector3d norm0 = new Vector3d(0.0, 1.0, 0.0).mul((Matrix3dc)basis0);
        Vector3d origin1 = new Vector3d((Vector3dc)origin0);
        Matrix3d basis1 = new Matrix3d((Matrix3dc)basis0);
        Vector3d grad1 = new Vector3d((Vector3dc)grad0);
        start.interpolate(end, t1, origin1, basis1, grad1);
        Vector3d norm1 = new Vector3d(0.0, 1.0, 0.0).mul((Matrix3dc)basis1);
        for (v0 = (float)blockProgress[0]; v0 > 1.0f; v0 -= 1.0f) {
        }
        float v1 = v0 + (float)(grad0.length() * (t1 - t0));
        blockProgress[0] = v1;
        v1 = 1.0f - v1 + vOffset;
        v0 = 1.0f - v0 + vOffset;
        class_2338 pos0 = new class_2338(class_3532.method_15357((double)origin0.x()), class_3532.method_15357((double)origin0.y()), class_3532.method_15357((double)origin0.z()));
        class_2338 pos1 = new class_2338(class_3532.method_15357((double)origin1.x()), class_3532.method_15357((double)origin1.y()), class_3532.method_15357((double)origin1.z()));
        int light0 = class_761.method_23794((class_1920)world, (class_2338)pos0);
        int light1 = class_761.method_23794((class_1920)world, (class_2338)pos1);
        Vector3f point = new Vector3f();
        point.set(0.5, 0.0, 0.0).mul((Matrix3dc)basis0).add((float)origin0.x(), (float)origin0.y(), (float)origin0.z());
        buffer.method_61032(entry, point).method_22915(color.x(), color.y(), color.z(), 1.0f).method_22913(u0, v0).method_22922(overlay).method_60803(light0).method_60831(entry, (float)norm0.x(), (float)norm0.y(), (float)norm0.z());
        point.set(-0.5, 0.0, 0.0).mul((Matrix3dc)basis0).add((float)origin0.x(), (float)origin0.y(), (float)origin0.z());
        buffer.method_61032(entry, point).method_22915(color.x(), color.y(), color.z(), 1.0f).method_22913(u1, v0).method_22922(overlay).method_60803(light0).method_60831(entry, (float)norm0.x(), (float)norm0.y(), (float)norm0.z());
        point.set(-0.5, 0.0, 0.0).mul((Matrix3dc)basis1).add((float)origin1.x(), (float)origin1.y(), (float)origin1.z());
        buffer.method_61032(entry, point).method_22915(color.x(), color.y(), color.z(), 1.0f).method_22913(u1, v1).method_22922(overlay).method_60803(light1).method_60831(entry, (float)norm1.x(), (float)norm1.y(), (float)norm1.z());
        point.set(0.5, 0.0, 0.0).mul((Matrix3dc)basis1).add((float)origin1.x(), (float)origin1.y(), (float)origin1.z());
        buffer.method_61032(entry, point).method_22915(color.x(), color.y(), color.z(), 1.0f).method_22913(u0, v1).method_22922(overlay).method_60803(light1).method_60831(entry, (float)norm1.x(), (float)norm1.y(), (float)norm1.z());
    }
}

