/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.splinecart.config;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import io.github.foundationgames.splinecart.config.ConfigOption;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public class Config
extends ArrayList<ConfigOption<?>> {
    public static final String VALUE_SET_KEY = "splinecart.config.set_value";
    public static final String VALUE_QUERY_KEY = "splinecart.config.query_value";
    public final String id;
    public final Supplier<Path> path;

    public Config(String id, Supplier<Path> path) {
        this.id = id;
        this.path = path;
    }

    public <S extends class_2172> LiteralArgumentBuilder<S> command(LiteralArgumentBuilder<S> cmd, BiConsumer<S, class_2561> feedbackSender) {
        for (ConfigOption opt : this) {
            cmd.then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)opt.key).then(opt.commandArg("value").executes(context -> {
                opt.setFromCommandAndSave(context, "value");
                feedbackSender.accept((Object)((class_2172)context.getSource()), (class_2561)class_2561.method_43469((String)VALUE_SET_KEY, (Object[])new Object[]{opt.key, opt.get()}));
                return 0;
            }))).executes(context -> {
                String descKey = String.format("splinecart.config.%s.%s.desc", this.id, opt.key);
                feedbackSender.accept((Object)((class_2172)context.getSource()), (class_2561)class_2561.method_43469((String)VALUE_QUERY_KEY, (Object[])new Object[]{opt.key, opt.get()}));
                feedbackSender.accept((Object)((class_2172)context.getSource()), (class_2561)class_2561.method_43471((String)descKey).method_27692(class_124.field_1080));
                return 0;
            }));
        }
        return cmd;
    }

    public <V, O extends ConfigOption<V>> O opt(O opt) {
        this.add(opt);
        return opt;
    }

    public ConfigOption.BooleanOption optBool(String key, boolean value) {
        return this.opt(new ConfigOption.BooleanOption(key, value, this));
    }

    public ConfigOption.IntOption optInt(String key, int value, int min, int max) {
        return this.opt(new ConfigOption.IntOption(key, value, new int[]{min, max}, this));
    }

    public ConfigOption.DoubleOption optDouble(String key, double value, double min, double max) {
        return this.opt(new ConfigOption.DoubleOption(key, value, new double[]{min, max}, this));
    }

    public void load() throws IOException {
        Path path = this.path.get();
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            Properties properties = new Properties();
            properties.load(in);
            for (ConfigOption opt : this) {
                opt.read(properties);
            }
        }
    }

    public void save() throws IOException {
        Path path = this.path.get();
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
            Properties properties = new Properties();
            for (ConfigOption opt : this) {
                opt.write(properties);
            }
            properties.store(out, this.id);
        }
    }
}

