/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.splinecart.config;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.foundationgames.splinecart.Splinecart;
import io.github.foundationgames.splinecart.config.Config;
import java.io.IOException;
import java.util.Properties;
import net.minecraft.class_2172;

public abstract class ConfigOption<T> {
    protected final Config owner;
    public final String key;
    protected T value;

    protected ConfigOption(String key, T initialValue, Config owner) {
        this.owner = owner;
        this.key = key;
        this.value = initialValue;
    }

    protected abstract void read(Properties var1);

    protected abstract void write(Properties var1);

    protected abstract ArgumentType<T> commandArgType();

    public final <S extends class_2172> RequiredArgumentBuilder<S, ?> commandArg(String name) {
        return RequiredArgumentBuilder.argument((String)name, this.commandArgType());
    }

    public T get() {
        return this.value;
    }

    public void set(T value) {
        this.value = value;
    }

    public void setAndSave(T value) {
        this.set(value);
        try {
            this.owner.save();
        }
        catch (IOException e) {
            Splinecart.LOGGER.error("Error saving config '{}' while setting value '{}={}'", new Object[]{this.owner.id, this.key, this.value, e});
        }
    }

    public abstract <S extends class_2172> void setFromCommandAndSave(CommandContext<S> var1, String var2);

    public static class DoubleOption
    extends ConfigOption<Double> {
        private final double[] bounds;

        public DoubleOption(String key, Double initialValue, double[] bounds, Config owner) {
            super(key, initialValue, owner);
            this.bounds = bounds;
        }

        @Override
        protected void read(Properties properties) {
            if (properties.containsKey(this.key)) {
                this.value = Double.parseDouble(properties.getProperty(this.key));
            }
        }

        @Override
        protected void write(Properties properties) {
            properties.setProperty(this.key, Double.toString((Double)this.value));
        }

        @Override
        public ArgumentType<Double> commandArgType() {
            if (this.bounds.length == 1) {
                return DoubleArgumentType.doubleArg((double)this.bounds[0]);
            }
            if (this.bounds.length == 2) {
                return DoubleArgumentType.doubleArg((double)this.bounds[0], (double)this.bounds[1]);
            }
            return DoubleArgumentType.doubleArg();
        }

        @Override
        public <S extends class_2172> void setFromCommandAndSave(CommandContext<S> ctx, String argName) {
            this.setAndSave(DoubleArgumentType.getDouble(ctx, (String)argName));
        }
    }

    public static class IntOption
    extends ConfigOption<Integer> {
        private final int[] bounds;

        public IntOption(String key, Integer initialValue, int[] bounds, Config owner) {
            super(key, initialValue, owner);
            this.bounds = bounds;
        }

        @Override
        protected void read(Properties properties) {
            if (properties.containsKey(this.key)) {
                this.value = Integer.parseInt(properties.getProperty(this.key));
            }
        }

        @Override
        protected void write(Properties properties) {
            properties.setProperty(this.key, Integer.toString((Integer)this.value));
        }

        @Override
        public ArgumentType<Integer> commandArgType() {
            if (this.bounds.length == 1) {
                return IntegerArgumentType.integer((int)this.bounds[0]);
            }
            if (this.bounds.length == 2) {
                return IntegerArgumentType.integer((int)this.bounds[0], (int)this.bounds[1]);
            }
            return IntegerArgumentType.integer();
        }

        @Override
        public <S extends class_2172> void setFromCommandAndSave(CommandContext<S> ctx, String argName) {
            this.setAndSave(IntegerArgumentType.getInteger(ctx, (String)argName));
        }
    }

    public static class BooleanOption
    extends ConfigOption<Boolean> {
        public BooleanOption(String key, Boolean initialValue, Config owner) {
            super(key, initialValue, owner);
        }

        @Override
        protected void read(Properties properties) {
            if (properties.containsKey(this.key)) {
                this.value = "true".equals(properties.getProperty(this.key));
            }
        }

        @Override
        protected void write(Properties properties) {
            properties.setProperty(this.key, (Boolean)this.value != false ? "true" : "false");
        }

        @Override
        public ArgumentType<Boolean> commandArgType() {
            return BoolArgumentType.bool();
        }

        @Override
        public <S extends class_2172> void setFromCommandAndSave(CommandContext<S> ctx, String argName) {
            this.setAndSave(BoolArgumentType.getBool(ctx, (String)argName));
        }
    }
}

