/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.splinecart.entity;

import io.github.foundationgames.splinecart.Splinecart;
import io.github.foundationgames.splinecart.block.TrackMarkerBlockEntity;
import io.github.foundationgames.splinecart.util.Pose;
import io.github.foundationgames.splinecart.util.SUtil;
import java.util.LinkedList;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class TrackFollowerEntity
extends class_1297 {
    public static final double GRAVITY_MPS2 = 9.81;
    public static final double GRAVITY = 0.024525;
    public static final double METERS_PER_TICK_TO_KMH = 72.0;
    public static final double KMH_TO_MPH = 0.6213712;
    @Nullable
    private class_2338 startTie;
    @Nullable
    private class_2338 endTie;
    private double splinePieceProgress = 0.0;
    private double motionScale;
    private double trackVelocity;
    private final Vector3d serverPosition = new Vector3d();
    private final Vector3d serverVelocity = new Vector3d();
    private int positionInterpSteps;
    private int oriInterpSteps;
    private static final class_2940<Quaternionf> ORIENTATION = class_2945.method_12791(TrackFollowerEntity.class, (class_2941)class_2943.field_42235);
    private final Matrix3d basis = new Matrix3d().identity();
    private final Quaternionf lastClientOrientation = new Quaternionf();
    private final Quaternionf clientOrientation = new Quaternionf();
    private boolean hadPassenger = false;
    private boolean hadPlayerPassenger = false;
    private final LinkedList<Vector3d> lastVelocities = new LinkedList();
    private Vector3d peakVelocity = new Vector3d();
    private boolean firstPositionUpdate = true;
    private boolean firstOriUpdate = true;
    private class_243 clientMotion = class_243.field_1353;
    private int ticksSinceRemoved = 6;
    private static final int DEFAULT_TICKS_SINCE_REMOVED = 6;

    public TrackFollowerEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    public TrackFollowerEntity(class_1937 world) {
        this(Splinecart.TRACK_FOLLOWER, world);
    }

    @Nullable
    public static TrackFollowerEntity create(class_1937 world, class_2338 startMarkerPos, double trackVelocity) {
        TrackMarkerBlockEntity startMarker = TrackMarkerBlockEntity.of(world, startMarkerPos);
        if (startMarker == null) {
            return null;
        }
        class_2338 endMarkerPos = startMarker.getNextTrackMarkerPos();
        TrackFollowerEntity follower = new TrackFollowerEntity(world);
        TrackMarkerBlockEntity endMarker = TrackMarkerBlockEntity.of(world, endMarkerPos);
        follower.method_33574(SUtil.toCenteredVec3d((class_2382)startMarkerPos));
        if (endMarker == null) {
            startMarker.triggers.execute(world);
            follower.splinePieceProgress = 1.0;
            endMarkerPos = startMarkerPos;
            startMarkerPos = startMarker.getPrevTrackMarkerPos();
        } else {
            follower.splinePieceProgress = 0.0;
        }
        if (trackVelocity >= 0.0) {
            startMarker.triggers.execute(world);
        }
        follower.trackVelocity = trackVelocity;
        follower.setStretch(startMarkerPos, endMarkerPos);
        follower.method_5841().method_12778(ORIENTATION, (Object)startMarker.pose().basis().getNormalizedRotation(new Quaternionf()));
        return follower;
    }

    public void setStretch(@Nullable class_2338 start, @Nullable class_2338 end) {
        this.startTie = start;
        this.endTie = end;
    }

    protected void interpPos(int step) {
        double t = 1.0 / (double)step;
        Vector3d clientPos = new Vector3d(this.method_23317(), this.method_23318(), this.method_23321());
        class_243 velocity = this.method_18798();
        Vector3d clientVel = new Vector3d(velocity.method_10216(), velocity.method_10214(), velocity.method_10215());
        Vector3d newClientPos = new Vector3d();
        Vector3d newClientVel = new Vector3d();
        Pose.cubicHermiteSpline(t, 1.0, (Vector3dc)clientPos, (Vector3dc)clientVel, (Vector3dc)this.serverPosition, (Vector3dc)this.serverVelocity, newClientPos, newClientVel);
        this.method_5814(newClientPos.x(), newClientPos.y(), newClientPos.z());
        this.method_18800(newClientVel.x(), newClientVel.y(), newClientVel.z());
    }

    public void method_5773() {
        super.method_5773();
        if (super.method_37908().method_8608()) {
            this.updateClient();
            this.updateRidingPassenger();
        } else {
            this.updateServer();
        }
    }

    protected void updateRidingPassenger() {
        class_1297 cart = super.method_31483();
        if (cart == null) {
            return;
        }
        class_1297 passenger = cart.method_31483();
        this.updatePlayerFacing(passenger);
        if (passenger == null) {
            return;
        }
        if (passenger instanceof class_1657) {
            this.updateSpeedInfo();
        }
    }

    protected void updatePlayerFacing(class_1297 passenger) {
        if (passenger == null && this.hadPlayerPassenger) {
            this.hadPlayerPassenger = false;
        }
        if (passenger != null && !this.hadPlayerPassenger) {
            if (passenger instanceof class_1657) {
                class_1657 player = (class_1657)passenger;
                player.method_36456(90.0f);
                player.method_36457(0.0f);
            }
            this.hadPlayerPassenger = true;
        }
    }

    protected void updateSpeedInfo() {
        this.lastVelocities.addFirst(new Vector3d((Vector3dc)this.serverVelocity));
        if (this.lastVelocities.size() <= 3) {
            return;
        }
        this.lastVelocities.removeLast();
        if (this.lastVelocities.getFirst().length() > this.lastVelocities.get(1).length() && this.lastVelocities.get(1).length() < this.lastVelocities.get(2).length()) {
            this.peakVelocity = new Vector3d((Vector3dc)this.lastVelocities.get(1));
        } else if (this.lastVelocities.getFirst().length() < this.lastVelocities.get(1).length() && this.lastVelocities.get(1).length() > this.lastVelocities.get(2).length()) {
            this.peakVelocity = new Vector3d((Vector3dc)this.lastVelocities.get(1));
        }
    }

    public class_2561 getSpeedInfo(boolean showPeakSpeed, boolean showForce, boolean imperial) {
        Object msg = TrackFollowerEntity.formatSpeed(this.lastVelocities.getFirst().length(), imperial);
        if (showPeakSpeed) {
            msg = (String)msg + " peak: " + TrackFollowerEntity.formatSpeed(this.peakVelocity.length(), imperial);
        }
        if (showForce && this.lastVelocities.size() >= 3) {
            Vector3d acceleration = new Vector3d((Vector3dc)this.lastVelocities.getFirst()).sub((Vector3dc)this.lastVelocities.get(2)).mul(0.5).add(0.0, 0.024525, 0.0);
            msg = (String)msg + " force: " + TrackFollowerEntity.doubleToString(acceleration.length() / 0.024525) + " G";
        }
        return class_2561.method_30163((String)msg);
    }

    private static String formatSpeed(double metersPerTick, boolean imperial) {
        return TrackFollowerEntity.doubleToString(metersPerTick * 72.0 * (imperial ? 0.6213712 : 1.0)) + (imperial ? " mph" : " km/h");
    }

    private static String doubleToString(double value) {
        String str = value + "00";
        if (str.contains("E")) {
            return "0.00";
        }
        int index = str.indexOf(".");
        return str.substring(0, index + 2 + 1);
    }

    public void getClientOrientation(Quaternionf q, float tickDelta) {
        this.lastClientOrientation.slerp((Quaternionfc)this.clientOrientation, tickDelta, q);
    }

    public class_243 getClientMotion() {
        return this.clientMotion;
    }

    public Matrix3dc getServerBasis() {
        return this.basis;
    }

    public void destroy() {
        this.method_5650(class_1297.class_5529.field_26998);
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        return false;
    }

    private void flyOffTrack(class_1297 firstPassenger) {
        --this.ticksSinceRemoved;
        if (this.ticksSinceRemoved <= 0) {
            firstPassenger.method_5650(class_1297.class_5529.field_26998);
            this.destroy();
        }
    }

    protected void updateClient() {
        this.clientMotion = this.method_19538().method_22882();
        if (this.positionInterpSteps > 0) {
            this.interpPos(this.positionInterpSteps);
            --this.positionInterpSteps;
        } else {
            this.method_23311();
            this.method_18800(this.serverVelocity.x(), this.serverVelocity.y(), this.serverVelocity.z());
        }
        this.clientMotion = this.clientMotion.method_1019(this.method_19538());
        this.lastClientOrientation.set((Quaternionfc)this.clientOrientation);
        if (this.oriInterpSteps > 0) {
            float delta = 1.0f / (float)this.oriInterpSteps;
            this.clientOrientation.slerp((Quaternionfc)this.method_5841().method_12789(ORIENTATION), delta);
            --this.oriInterpSteps;
        } else {
            this.clientOrientation.set((Quaternionfc)this.method_5841().method_12789(ORIENTATION));
        }
    }

    protected void updateServer() {
        for (class_1297 passenger : this.method_5685()) {
            passenger.field_6017 = 0.0f;
        }
        class_1297 passenger = this.method_31483();
        if (passenger == null) {
            if (this.hadPassenger) {
                this.destroy();
            }
            return;
        }
        if (!this.hadPassenger) {
            this.hadPassenger = true;
            return;
        }
        class_1937 world = this.method_37908();
        TrackMarkerBlockEntity startE = TrackMarkerBlockEntity.of(world, this.startTie);
        TrackMarkerBlockEntity endE = TrackMarkerBlockEntity.of(world, this.endTie);
        if (startE == null || endE == null) {
            this.destroy();
            return;
        }
        this.splinePieceProgress += this.trackVelocity * this.motionScale;
        if (this.splinePieceProgress > 1.0) {
            this.splinePieceProgress = 0.0;
            endE.setLastVelocity(super.method_18798().method_1033());
            this.markerTransition(endE);
            TrackMarkerBlockEntity nextE = endE.getNextMarker();
            if (nextE == null) {
                this.flyOffTrack(passenger);
                this.splinePieceProgress = 1.0;
                return;
            }
            this.setStretch(this.endTie, nextE.method_11016());
            startE = endE;
            endE = nextE;
        } else if (this.splinePieceProgress < 0.0) {
            this.splinePieceProgress = 1.0;
            startE.setLastVelocity(-super.method_18798().method_1033());
            this.markerTransition(startE);
            TrackMarkerBlockEntity prevE = startE.getPrevMarker();
            if (prevE == null) {
                this.flyOffTrack(passenger);
                this.splinePieceProgress = 0.0;
                return;
            }
            this.setStretch(prevE.method_11016(), this.startTie);
            endE = startE;
            startE = prevE;
        }
        Vector3d pos = new Vector3d();
        Vector3d grad = new Vector3d();
        startE.pose().interpolate(endE.pose(), this.splinePieceProgress, pos, this.basis, grad);
        this.method_5814(pos.x(), pos.y(), pos.z());
        this.method_5841().method_12778(ORIENTATION, (Object)this.basis.getNormalizedRotation(new Quaternionf()));
        if (grad.length() != 0.0) {
            this.motionScale = 1.0 / grad.length();
        }
        Vector3d ngrad = new Vector3d((Vector3dc)grad).normalize();
        double gravity = -ngrad.y() * 0.024525;
        double dt = this.trackVelocity * this.motionScale;
        grad.mul(dt);
        this.method_18800(grad.x(), grad.y(), grad.z());
        class_243 passengerVel = passenger.method_18798();
        Vector3d push = new Vector3d(passengerVel.method_10216(), 0.0, passengerVel.method_10215());
        if (push.lengthSquared() > 1.0E-4) {
            Vector3d forward = new Vector3d(0.0, 0.0, 1.0).mul((Matrix3dc)this.basis);
            double linearPush = forward.dot((Vector3dc)push) * 2.0;
            this.trackVelocity += linearPush;
            passenger.method_18799(class_243.field_1353);
        }
        Vector3d gradeVec = new Vector3d(0.0, 1.0, 0.0).mul((Matrix3dc)this.basis);
        gradeVec.mul(1.0, 0.0, 1.0);
        double power = startE.computePower();
        double strength = startE.computeStrength();
        this.trackVelocity += gravity;
        this.trackVelocity = startE.nextType.motion.calculate(this.trackVelocity, gradeVec.length(), power, strength, (double)((class_3218)world).method_64395().method_8356(Splinecart.COASTER_FRICTION) * 1.0E-4);
    }

    private void markerTransition(TrackMarkerBlockEntity marker) {
        marker.method_5431();
        if (this.ticksSinceRemoved == 6) {
            marker.triggers.execute(marker.method_10997());
        }
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps) {
        if (this.firstPositionUpdate) {
            this.firstPositionUpdate = false;
            super.method_5759(x, y, z, yaw, pitch, interpolationSteps);
        }
        this.serverPosition.set(x, y, z);
        this.positionInterpSteps = interpolationSteps + 2;
        this.method_60608(yaw, pitch);
    }

    public void method_5750(double x, double y, double z) {
        this.serverVelocity.set(x, y, z);
    }

    protected void method_5865(class_1297 passenger, class_1297.class_4738 positionUpdater) {
        positionUpdater.accept(passenger, this.method_23317(), this.method_23318(), this.method_23321());
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(ORIENTATION, (Object)new Quaternionf().identity());
    }

    public void method_5674(class_2940<?> data) {
        super.method_5674(data);
        if (data.equals(ORIENTATION)) {
            if (this.firstOriUpdate) {
                this.firstOriUpdate = false;
                this.clientOrientation.set((Quaternionfc)this.method_5841().method_12789(ORIENTATION));
                this.lastClientOrientation.set((Quaternionfc)this.clientOrientation);
            }
            this.oriInterpSteps = this.method_5864().method_18388() + 2;
        }
    }

    protected void method_5749(class_2487 nbt) {
        this.startTie = SUtil.getBlockPos(nbt, "startMarkerPos");
        this.endTie = SUtil.getBlockPos(nbt, "endMarkerPos");
        this.trackVelocity = nbt.method_10574("track_velocity");
        this.motionScale = nbt.method_10574("motion_scale");
        this.splinePieceProgress = nbt.method_10574("spline_piece_progress");
    }

    protected void method_5652(class_2487 nbt) {
        SUtil.putBlockPos(nbt, this.startTie, "startMarkerPos");
        SUtil.putBlockPos(nbt, this.endTie, "endMarkerPos");
        nbt.method_10549("track_velocity", this.trackVelocity);
        nbt.method_10549("motion_scale", this.motionScale);
        nbt.method_10549("spline_piece_progress", this.splinePieceProgress);
    }
}

